define('confluence-like-mobile/like-model', [
    'backbone'
], function(
    Backbone
) {
    "use strict";

    return Backbone.Model.extend({
        /**
         * @param attributes a hash where "username" is a required property.
         * @param options
         */
        initialize: function (attributes, options) {
            if (!attributes) {
                throw new Error("Attributes is required");
            }

            if (!attributes.username) {
                throw new Error("username is a required attribute");
            }
        }
    });
});

require('confluence/module-exporter').exportModuleAsGlobal('confluence-like-mobile/like-model', 'ConfluenceMobile.Like');