/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications.dao;

import com.atlassian.confluence.plugins.like.notifications.LikeNotification;
import com.atlassian.confluence.plugins.like.notifications.dao.NotificationDao;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CacheBackedNotificationDao
implements NotificationDao,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CacheBackedNotificationDao.class);
    private static final String CACHE_NAME = NotificationDao.class.getName();
    private final Supplier<StableReadExternalCache<Boolean>> cacheRef = Lazy.supplier(() -> CacheBackedNotificationDao.createCache(cacheFactory));

    public CacheBackedNotificationDao(VCacheFactory cacheFactory) {
    }

    public void afterPropertiesSet() throws Exception {
        this.cache();
    }

    private static StableReadExternalCache<Boolean> createCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(Boolean.class), new ExternalCacheSettingsBuilder().defaultTtl(Duration.ofDays(14L)).build());
    }

    @Override
    public boolean exists(LikeNotification notification) {
        return ((Optional)VCacheUtils.fold((CompletionStage)this.cache().get(CacheBackedNotificationDao.cacheKey(notification)), Function.identity(), ex -> {
            log.warn("Failed to retrieve cache entry: {}", (Object)ex.getMessage());
            return Optional.empty();
        })).orElse(false);
    }

    @Override
    public void save(LikeNotification notification) {
        VCacheUtils.fold((CompletionStage)this.cache().put(CacheBackedNotificationDao.cacheKey(notification), (Object)Boolean.TRUE, PutPolicy.ADD_ONLY), Function.identity(), ex -> {
            log.warn("Failed to put cache entry: {}", (Object)ex.getMessage());
            return false;
        });
    }

    private StableReadExternalCache<Boolean> cache() {
        return (StableReadExternalCache)this.cacheRef.get();
    }

    private static String cacheKey(LikeNotification notification) {
        return String.format("%s-%s", notification.getRecipient().getName(), notification.getContent().getId());
    }
}

