/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.notifications.CachedContentFinder;
import com.atlassian.confluence.plugins.like.notifications.AbstractLikeEventRenderContextProvider;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class LikeEventHipChatRenderContextProvider
extends AbstractLikeEventRenderContextProvider {
    public LikeEventHipChatRenderContextProvider(CachedContentFinder cachedContentFinder, UserAccessor userAccessor, FollowManager followManager, LocaleManager localeManager) {
        super(cachedContentFinder, userAccessor, followManager, localeManager);
    }

    @Override
    protected Expansion[] getMediumSpecificExpansions(CachedContentFinder cachedContentFinder) {
        return new Expansion[]{new Expansion("space"), new Expansion("history")};
    }

    @Override
    protected Maybe<Map<String, Object>> getMediumSpecificContext(Content content, LikePayload payload, boolean recipientIsAuthor) {
        String headerActionStringKey = "likes.notification.hipchat.header.likes." + (recipientIsAuthor ? "your." : "") + payload.getContentType();
        String subjectStringKey = "likes.notification.hipchat.body.likes." + (recipientIsAuthor ? "your." : "") + payload.getContentType();
        HashMap context = Maps.newHashMap();
        context.put("headerActionStringKey", headerActionStringKey);
        context.put("subjectStringKey", subjectStringKey);
        return Option.some((Object)context);
    }
}

