/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.notifications;

import com.atlassian.confluence.api.model.BaseApiEnum;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.MaybeNot;
import com.atlassian.confluence.event.events.like.LikeEvent;
import com.atlassian.confluence.notifications.PayloadTransformerTemplate;
import com.atlassian.confluence.notifications.batch.payload.BatchingPayloadTransformer;
import com.atlassian.confluence.notifications.batch.service.BatchingKey;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.like.notifications.LikePayload;
import com.atlassian.confluence.plugins.like.notifications.SimpleLikePayload;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;

public class CreateLikeEventPayloadTransformer
extends PayloadTransformerTemplate<LikeEvent, LikePayload>
implements BatchingPayloadTransformer<LikePayload> {
    private final UserAccessor userAccessor;

    protected CreateLikeEventPayloadTransformer(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public BatchingKey getBatchingColumnValue(LikePayload likePayload) {
        if (likePayload == null || !likePayload.getContentType().in(new BaseApiEnum[]{ContentType.BLOG_POST, ContentType.PAGE, ContentType.COMMENT})) {
            return BatchingKey.NO_BATCHING;
        }
        return new BatchingKey(Long.toString(likePayload.getContentId()), likePayload.getContentType().getType());
    }

    protected Maybe<LikePayload> checkedCreate(LikeEvent likeEvent) {
        ContentEntityObject owner;
        ContentEntityObject content = likeEvent.getContent();
        User originatingUser = likeEvent.getOriginatingUser();
        if (originatingUser == null) {
            return MaybeNot.becauseOf((String)"Can't create payload as user is anonymous. Anonymous users cannot like content.", (Object[])new Object[0]);
        }
        if (content instanceof Comment && (owner = ((Comment)content).getContainer()) == null) {
            return MaybeNot.becauseOf((String)"The page should not be null for a comment", (Object[])new Object[0]);
        }
        UserKey userKey = originatingUser instanceof ConfluenceUser ? ((ConfluenceUser)originatingUser).getKey() : this.userAccessor.getUserByName(originatingUser.getName()).getKey();
        SimpleLikePayload payload = new SimpleLikePayload(content.getId(), ContentType.valueOf((String)content.getType()), userKey.getStringValue());
        return Option.some((Object)payload);
    }
}

