/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.security.access.annotations.RequiresAnyConfluenceAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.atlassian.xwork.RequireSecurityToken;
import com.opensymphony.webwork.ServletActionContext;

@RequiresAnyConfluenceAccess
public class LikeAction
extends ConfluenceActionSupport {
    private LikeManager likeManager;
    private ContentEntityManager contentEntityManager;
    private long contentId;
    private String url;

    @RequireSecurityToken(value=true)
    public String execute() throws Exception {
        ContentEntityObject content = this.contentEntityManager.getById(this.contentId);
        if (content == null) {
            ServletActionContext.getResponse().setStatus(404);
            return "error";
        }
        this.likeManager.addLike(content, (User)AuthenticatedUserThreadLocal.get());
        this.url = content.getUrlPath();
        if (!(content instanceof Comment)) {
            this.url = this.url + "#like-section";
        }
        return "success";
    }

    public String getRedirectUrl() {
        return this.url;
    }

    public void setLikeManager(LikeManager likeManager) {
        this.likeManager = likeManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }
}

