/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.like;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.plugins.like.LikeSummaryCreator;
import com.atlassian.confluence.plugins.like.UserEntityExpander;
import com.atlassian.confluence.plugins.like.rest.entities.LikeEntity;
import com.atlassian.confluence.plugins.like.rest.entities.UserEntity;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;

@Deprecated
public class DefaultLikeSummaryCreator
implements LikeSummaryCreator {
    static final int MAX_PROMOTED = 3;
    private final UserEntityExpander userEntityExpander;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;

    public DefaultLikeSummaryCreator(UserEntityExpander userEntityExpander, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.userEntityExpander = userEntityExpander;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    @Override
    public String createSummary(ContentEntityObject contentEntity, List<Like> likes, Set<String> followees) {
        if (contentEntity == null || likes == null || likes.isEmpty()) {
            return "";
        }
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
        Message message = this.createSummary(contentEntity, likes, followees, (User)AuthenticatedUserThreadLocal.get());
        return "<span class=\"like-summary-text\">" + i18NBean.getText(message.getKey(), message.getArguments()) + "</span>";
    }

    Message createSummary(ContentEntityObject contentEntity, List<Like> likes, Set<String> followees, User remoteUser) {
        if (followees == null) {
            followees = Collections.emptySet();
        }
        if (likes == null) {
            likes = Collections.emptyList();
        }
        LikeEntity me = null;
        LinkedList<LikeEntity> promoted = new LinkedList<LikeEntity>();
        LinkedList<LikeEntity> nonPromoted = new LinkedList<LikeEntity>();
        for (Like like : likes) {
            LikeEntity likeEntity = new LikeEntity(like.getUsername());
            if (like.getUsername().equals(remoteUser == null ? null : remoteUser.getName())) {
                me = likeEntity;
                continue;
            }
            if (promoted.size() < 3 && followees.contains(like.getUsername())) {
                promoted.add(likeEntity);
                continue;
            }
            nonPromoted.add(likeEntity);
        }
        StringBuilder i18nKey = new StringBuilder("likes.summary");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (me != null) {
            i18nKey.append(".you");
        }
        if (promoted.size() > 0) {
            i18nKey.append(".").append(promoted.size()).append(".promoted");
            linkedList.addAll(this.toUserLinks(promoted));
        }
        if (nonPromoted.size() == 1) {
            i18nKey.append(".1.non-promoted");
            linkedList.add(this.createUserLink(((LikeEntity)nonPromoted.get(0)).getUserEntity()));
        } else if (nonPromoted.size() > 1) {
            i18nKey.append(".x.non-promoted");
            linkedList.add(nonPromoted.size());
            linkedList.add(String.format("class=\"likes\" data-content-id=\"%d\"", contentEntity.getId()));
        }
        return Message.getInstance((String)i18nKey.toString(), (Object[])(linkedList.isEmpty() ? null : linkedList.toArray()));
    }

    private List<Object> toUserLinks(List<LikeEntity> likes) {
        LinkedList<Object> userLinks = new LinkedList<Object>();
        for (LikeEntity likeEntity : likes) {
            userLinks.add(this.createUserLink(likeEntity.getUserEntity()));
        }
        return userLinks;
    }

    String createUserLink(UserEntity userEntity) {
        userEntity = this.userEntityExpander.expand(userEntity);
        return String.format("<a href=\"%s\" class=\"confluence-userlink\" data-username=\"%s\">%s</a>", userEntity.getUrl(), StringEscapeUtils.escapeHtml4((String)userEntity.getName()), StringEscapeUtils.escapeHtml4((String)userEntity.getFullName()));
    }
}

