/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license.rest.service;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.license.rest.service.UserCountService;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.google.common.base.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCountServiceImpl
implements UserCountService {
    private final Logger log = LoggerFactory.getLogger(UserCountServiceImpl.class);
    private final UserChecker userChecker;
    private final LicenseService licenseService;

    public UserCountServiceImpl(UserChecker userChecker, LicenseService licenseService) {
        this.userChecker = userChecker;
        this.licenseService = licenseService;
    }

    @Override
    public Integer getUserCount() {
        return this.userChecker.getNumberOfRegisteredUsers();
    }

    @Override
    public Optional<Integer> getRemainingFreeSlots() {
        try {
            Integer userCount = this.getUserCount();
            Integer licenseMaxUsers = this.getLicenseMaxUsers();
            if (licenseMaxUsers == Integer.MAX_VALUE) {
                return Optional.of((Object)Integer.MAX_VALUE);
            }
            return Optional.of((Object)(licenseMaxUsers - userCount));
        }
        catch (LicenseException e) {
            this.log.error("Could not retrieve license.", (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    public Integer getLicenseMaxUsers() {
        ConfluenceLicense license = this.licenseService.retrieve();
        if (license.isUnlimitedNumberOfUsers()) {
            return Integer.MAX_VALUE;
        }
        return license.getMaximumNumberOfUsers();
    }
}

