/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license.rest.resource;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.LicenseWebFacade;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.license.rest.model.UserCountResourceModel;
import com.atlassian.confluence.license.rest.service.UserCountService;
import com.atlassian.confluence.license.util.ConfluenceLicenseUtils;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.db.DatabaseUtils;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.common.base.Optional;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/license")
public class LicenseResource {
    private static final Logger log = LoggerFactory.getLogger(LicenseResource.class);
    private final UserCountService userCountService;
    private final PermissionManager permissionManager;
    private final LicenseWebFacade licenseWebFacade;
    private final ClusterManager clusterManager;
    private final I18nResolver i18nResolver;
    private final LicenseService licenseService;

    public LicenseResource(UserCountService userCountService, PermissionManager permissionManager, LicenseWebFacade licenseWebFacade, ClusterManager clusterManager, I18nResolver i18nResolver, LicenseService licenseService) {
        this.userCountService = userCountService;
        this.permissionManager = permissionManager;
        this.licenseWebFacade = licenseWebFacade;
        this.clusterManager = clusterManager;
        this.i18nResolver = i18nResolver;
        this.licenseService = licenseService;
    }

    @GET
    @Path(value="/organisation")
    public Response getOrganisation() {
        if (this.isAdmin()) {
            try {
                String org = this.licenseService.retrieve().getOrganisation().getName();
                return Response.ok((Object)org).build();
            }
            catch (LicenseException e) {
                log.error("License not found or cannot be decrypted.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        log.error("Non admin user attempted to access /organisation end point: " + AuthenticatedUserThreadLocal.getUsername());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="/userCount")
    public Response getUserCount() {
        if (this.isAdmin()) {
            Integer userCount = this.userCountService.getUserCount();
            log.info("There are " + userCount + " users on this instance.");
            return Response.ok((Object)new UserCountResourceModel(userCount)).build();
        }
        log.error("Non admin user attemped to access /userCount end point: " + AuthenticatedUserThreadLocal.getUsername());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="/remainingSeats")
    public Response getRemainingUserCount() {
        if (this.isAdmin()) {
            Optional<Integer> remainingFreeSlots = this.userCountService.getRemainingFreeSlots();
            if (remainingFreeSlots.isPresent()) {
                log.info("There are " + remainingFreeSlots + " remaining free slots on this instance.");
                return Response.ok((Object)new UserCountResourceModel((Integer)remainingFreeSlots.get())).build();
            }
            log.error("Could not retrieve number of free slots for this instance.");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        log.error("Non admin user attemped to access /remainingSeats end point: " + AuthenticatedUserThreadLocal.getUsername());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="/maxUsers")
    public Response getMaxUsers() {
        if (this.isAdmin()) {
            Integer maxUsers = this.userCountService.getLicenseMaxUsers();
            log.info("This license allows for " + maxUsers + " users");
            return Response.ok((Object)new UserCountResourceModel(maxUsers)).build();
        }
        log.error("Non admin user attemped to access /maxUsers end point: " + AuthenticatedUserThreadLocal.getUsername());
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="/validate")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response validate(@FormParam(value="licenseKey") String licenseKey) {
        return (Response)this.licenseWebFacade.validate(licenseKey).fold(errorMessage -> Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errorMessage).build(), license -> {
            if (ConfluenceLicenseUtils.isDataCenter((ConfluenceLicense)license) && DatabaseUtils.evaluationDatabaseName().isPresent()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("setup.start.cluster.upgrade.cannot.start.embedded.db", new Serializable[]{(Serializable)DatabaseUtils.evaluationDatabaseName().get()})).build();
            }
            return Response.ok((Object)this.migrationTriggered((ConfluenceLicense)license)).build();
        });
    }

    private boolean migrationTriggered(ConfluenceLicense license) {
        return ConfluenceLicenseUtils.isDataCenter((ConfluenceLicense)license) != this.clusterManager.isClustered();
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
    }
}

