/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.labels.actions;

import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.actions.json.ContentNameMatch;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.search.contentnames.QueryToken;
import com.atlassian.confluence.search.contentnames.QueryTokenizer;
import com.atlassian.confluence.security.access.annotations.RequiresAnyConfluenceAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresAnyConfluenceAccess
public class AutocompleteLabelsAction
extends ConfluenceActionSupport
implements Beanable {
    private static final int DEFAULT_MAX = 50;
    private static final QueryTokenizer tokenizer = query1 -> {
        String[] queryTokens;
        ArrayList result1 = Lists.newArrayList();
        result1.add(new QueryToken(query1, QueryToken.Type.FULL));
        for (String q : queryTokens = query1.split("[\\s,]")) {
            result1.add(new QueryToken(q, QueryToken.Type.PARTIAL));
        }
        return result1;
    };
    private PageManager pageManager;
    private LabelManagerInternal labelManager;
    private String query;
    private long contentId;
    private int maxResults;
    private ContentNameSearchResult result;
    private List<String> errors = new ArrayList<String>();
    private String spaceKey;
    private boolean ignoreRelated;

    public String execute() throws Exception {
        if (this.query == null) {
            this.errors.add(this.getText("autocomplete.label.query.empty"));
            return "error";
        }
        if (this.maxResults <= 0) {
            this.maxResults = 50;
        }
        this.findLabels();
        return "success";
    }

    private void findLabels() {
        int missing;
        this.query = this.query.trim().toLowerCase();
        AbstractPage entity = this.pageManager.getAbstractPage(this.contentId);
        List queryTokens = tokenizer.tokenize(this.query);
        this.result = new ContentNameSearchResult(this.query);
        this.result.setQueryTokens(queryTokens);
        List<Label> suggestedLabels = Collections.emptyList();
        if (!this.ignoreRelated) {
            suggestedLabels = this.getSuggestedLabels(queryTokens, entity);
            this.result.addMatchGroup(this.asMatches(suggestedLabels));
        }
        if ((missing = this.maxResults - suggestedLabels.size()) > 0 && queryTokens.size() == 2) {
            String prefix = ((QueryToken)queryTokens.get(0)).getText();
            PageResponse labelsPartial = this.labelManager.findGlobalLabelsByNamePrefix(prefix, LimitedRequestImpl.create((int)0, (int)missing, (int)50));
            ArrayList labelsByPrefix = Lists.newArrayList((Iterable)labelsPartial.getResults());
            labelsByPrefix.removeAll(suggestedLabels);
            if (!labelsByPrefix.isEmpty()) {
                this.result.addMatchGroup(this.asMatches(labelsByPrefix));
            }
        }
    }

    private List<Label> getSuggestedLabels(List<QueryToken> queryTokens, AbstractPage entity) {
        ArrayList suggestedLabels = Lists.newArrayList();
        List<String> unparsedLabelNames = this.getStringsFromTokens(queryTokens);
        List exactMatchLabels = this.labelManager.getLabels(unparsedLabelNames);
        suggestedLabels.addAll(exactMatchLabels);
        String remoteUser = AuthenticatedUserThreadLocal.getUsername();
        List<Label> hipsterLabels = entity != null ? LabelUtil.getRecentAndPopularLabelsForEntity((ContentEntityObject)entity, (LabelManager)this.labelManager, (int)50, (String)remoteUser) : LabelUtil.getRecentAndPopularLabels((String)this.spaceKey, (LabelManager)this.labelManager, (int)50, (String)remoteUser);
        hipsterLabels.removeAll(exactMatchLabels);
        hipsterLabels = this.filterLabelsByQuery(hipsterLabels, queryTokens);
        hipsterLabels = this.sortLabels(hipsterLabels);
        suggestedLabels.addAll(hipsterLabels);
        return suggestedLabels.size() > this.maxResults ? suggestedLabels.subList(0, this.maxResults) : suggestedLabels;
    }

    private List<Label> sortLabels(List<Label> labels) {
        Collections.sort(labels, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return labels;
    }

    private List<String> getStringsFromTokens(List<QueryToken> queryTokens) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(queryTokens, input -> input.getType() == QueryToken.Type.PARTIAL), QueryToken::getText));
    }

    private List<ContentNameMatch> asMatches(List<Label> labels) {
        return Lists.transform(labels, input -> new ContentNameMatch("label-suggestion", input.getName(), input.getUrlPath()));
    }

    private List<Label> filterLabelsByQuery(List<Label> suggestedLabels, List<QueryToken> queryTokens) {
        ArrayList labels = Lists.newArrayList();
        block0: for (Label label : suggestedLabels) {
            for (QueryToken t : queryTokens) {
                if (!label.getName().startsWith(t.getText())) continue;
                labels.add(label);
                if (labels.size() < this.maxResults) continue block0;
                return labels;
            }
        }
        return labels;
    }

    public Object getBean() {
        if (this.result != null) {
            return this.result;
        }
        return this.errors;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = (LabelManagerInternal)labelManager;
        super.setLabelManager(labelManager);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setIgnoreRelated(boolean ignoreRelated) {
        this.ignoreRelated = ignoreRelated;
    }
}

