define('confluence-image-attributes/image-attributes-panel', [
    'jquery',
    'ajs',
    'confluence/legacy'
], function(
    $,
    AJS,
    Confluence
) {
    "use strict";

    function ImageAttributesPanel() {
        AJS.bind('dialog-created.image-properties', function(event, data) {
            $img = $(data.img);
            initPanel();
        });

        var panelKey = 'image-attributes';
        var panelClass = 'image-attributes-panel';
        var $img;
        var $titleField;
        var $altField;

        function initPanel() {
            var $panelContent = $(Confluence.Templates.Editor.ImageAttributes.content({
                imgTitle: $img.attr('data-element-title'),
                imgAlt: $img.attr('alt')
            }));
            $titleField = $panelContent.find('#image-title-attribute');
            $altField = $panelContent.find('#image-alt-attribute');
            chainTitleAndAltFields();
            Confluence.Editor.ImageProps.registerPanel(panelKey, $panelContent, panelClass, saveFn);
        }

        function saveFn() {
            var titleText = $titleField.val();
            $img.attr({
                'data-element-title': titleText,
                'title': getTitleAttributeValue($img.attr('data-location'), titleText),
                'alt': $altField.val()
            });
        }

        function chainTitleAndAltFields() {
            if ($titleField.val() === $altField.val()) {
                $titleField.bind('input.chained', function (e) {
                    $altField.val($titleField.val());
                });
                $altField.on('change', function() {
                    $titleField.unbind('input.chained');
                });
            }
        }

        function getTitleAttributeValue(location, title) {
            // In the editor we show the location of the attachment in the tooltip
            if (location && location.length > 0 && title && title.length > 0) {
                return location + ' (' + title + ')';
            }
            if (location && location.length > 0) {
                return location;
            }
            if (title && title.length > 0) {
                return '(' + title + ')';
            }
            return '';
        }
    }

    return ImageAttributesPanel;
});

require('confluence/module-exporter').safeRequire('confluence-image-attributes/image-attributes-panel', function(ImageAttributesPanel) {
    require('ajs').toInit(ImageAttributesPanel);
});
