/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.html;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.http.Authenticator;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.confluence.util.http.httpclient.TrustedTokenAuthenticator;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WhitelistedHttpRetrievalMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(WhitelistedHttpRetrievalMacro.class);
    private static final String WHITELIST_ERROR_TEMPLATE = "com/atlassian/confluence/plugins/macros/html/whitelist-error.vm";
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final HttpRetrievalService httpRetrievalService;
    private final TrustedTokenFactory trustedTokenFactory;
    private final OutboundWhitelist whitelist;

    protected WhitelistedHttpRetrievalMacro(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, HttpRetrievalService httpRetrievalService, TrustedTokenFactory trustedTokenFactory, OutboundWhitelist whitelist) {
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.httpRetrievalService = httpRetrievalService;
        this.trustedTokenFactory = trustedTokenFactory;
        this.whitelist = whitelist;
    }

    protected String getText(String i18nKey, List<String> substitution) {
        return this.getI18nBean().getText(i18nKey, substitution);
    }

    private I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(AuthenticatedUserThreadLocal.getUser()));
    }

    protected String getText(String i18nKey) {
        return this.getI18nBean().getText(i18nKey);
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    public final boolean hasBody() {
        return false;
    }

    public final RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private static String cleanupUrl(String url) {
        if (url.indexOf(40) > 0) {
            url = url.replaceAll("\\(", "%28");
        }
        if (url.indexOf(41) > 0) {
            url = url.replaceAll("\\)", "%29");
        }
        if (url.indexOf("&amp;") > 0) {
            url = url.replaceAll("&amp;", "&");
        }
        return url;
    }

    private static String renderDeniedByWhiteListConfiguration(String url) throws MacroExecutionException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("invalidURL", "true");
        contextMap.put("url", url);
        contextMap.put("remoteUser", AuthenticatedUserThreadLocal.getUser());
        try {
            return VelocityUtils.getRenderedTemplate((String)WHITELIST_ERROR_TEMPLATE, (Map)contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to display whitelist error!", (Throwable)e);
            throw new MacroExecutionException(e.getMessage());
        }
    }

    private static boolean useTrustedApps(Map<String, String> macroParams) {
        return !BooleanUtils.toBoolean((String)StringUtils.defaultString((String)macroParams.get("anonymous"), (String)Boolean.TRUE.toString()));
    }

    private String notFound(String url) {
        return RenderUtils.blockError((String)this.getText("whitelistedmacro.error.notfound", Arrays.asList(url)), (String)"");
    }

    private String notPermitted(String url) {
        return RenderUtils.blockError((String)this.getText("whitelistedmacro.error.notpermitted", Arrays.asList(url)), (String)"");
    }

    private String failed(String url, String statusMessage) {
        return RenderUtils.blockError((String)this.getText("whitelistedmacro.error.notpermitted", Arrays.asList(url)), (String)statusMessage);
    }

    private static boolean hasTrustedRequestFailed(HttpResponse httpResponse) {
        String[] trustedRequestStatuses = httpResponse.getHeaders("X-Seraph-Trusted-App-Status");
        return null != trustedRequestStatuses && Arrays.asList(trustedRequestStatuses).contains("ERROR");
    }

    private static Collection<String> getTrustedRequestFailureMessages(HttpResponse httpResponse) {
        String[] rawTrustedErrorMessages = httpResponse.getHeaders("X-Seraph-Trusted-App-Error");
        HashSet<String> errorMessages = new HashSet<String>();
        if (null != rawTrustedErrorMessages) {
            for (String rawTrustedErrorMessage : rawTrustedErrorMessages) {
                errorMessages.add(TrustedApplicationUtils.parseError((String)rawTrustedErrorMessage).toString());
            }
        }
        return errorMessages;
    }

    private String trustedRequestFailed(String url, HttpResponse httpResponse) {
        return RenderUtils.blockError((String)this.getText("whitelistedmacro.error.trustedrequestfailed", Arrays.asList(url)), (String)StringUtils.join(WhitelistedHttpRetrievalMacro.getTrustedRequestFailureMessages(httpResponse), (String)", "));
    }

    protected abstract String successfulResponse(Map<String, String> var1, ConversionContext var2, String var3, HttpResponse var4) throws MacroExecutionException;

    public String execute(Map<String, String> typeSafeMacroParams, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String url = WhitelistedHttpRetrievalMacro.cleanupUrl(StringUtils.defaultString((String)typeSafeMacroParams.get("0"), (String)StringUtils.defaultString((String)typeSafeMacroParams.get("url"))));
        if (StringUtils.isNotBlank((String)url)) {
            URI uri = WhitelistedHttpRetrievalMacro.toURI(url);
            if (uri == null || !this.whitelist.isAllowed(uri)) {
                return WhitelistedHttpRetrievalMacro.renderDeniedByWhiteListConfiguration(url);
            }
            HttpResponse response = null;
            boolean useTrustedApps = WhitelistedHttpRetrievalMacro.useTrustedApps(typeSafeMacroParams);
            HttpRequest httpRequest = this.httpRetrievalService.getDefaultRequestFor(url);
            if (useTrustedApps) {
                httpRequest.setAuthenticator((Authenticator)new TrustedTokenAuthenticator(this.trustedTokenFactory));
            }
            try {
                response = this.httpRetrievalService.get(httpRequest);
                if (response.isNotFound()) {
                    String string = this.notFound(url);
                    return string;
                }
                if (response.isNotPermitted()) {
                    String string = this.notPermitted(url);
                    return string;
                }
                if (response.isFailed()) {
                    String string = this.failed(url, response.getStatusMessage());
                    return string;
                }
                if (useTrustedApps && WhitelistedHttpRetrievalMacro.hasTrustedRequestFailed(response)) {
                    String string = this.trustedRequestFailed(url, response);
                    return string;
                }
                String string = this.successfulResponse(typeSafeMacroParams, conversionContext, url, response);
                return string;
            }
            catch (IOException ioe) {
                log.error("Unable to get HTTP response from " + url, (Throwable)ioe);
                throw new MacroExecutionException((Throwable)ioe);
            }
            catch (Exception npe) {
                log.error("Unable to get HTTP response from " + url, (Throwable)npe);
                throw new MacroExecutionException((Throwable)npe);
            }
            finally {
                if (null != response) {
                    response.finish();
                }
            }
        }
        return RenderUtils.error((String)this.getText("whitelistedmacro.error.nourl"));
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)parameters, body, (ConversionContext)null);
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }

    private static URI toURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

