/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.html;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.plugins.macros.html.WhitelistedHttpRetrievalMacro;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.util.FileUtils;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.wysiwyg.HtmlParserUtil;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class RssMacro
extends WhitelistedHttpRetrievalMacro {
    private static final Logger log = LoggerFactory.getLogger(RssMacro.class);
    private final BootstrapManager bootstrapManager;
    private final GateKeeper gateKeeper;
    private final VelocityHelperService velocityHelperService;
    private final RenderedContentCleaner contentCleaner;

    public RssMacro(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, HttpRetrievalService httpRetrievalService, TrustedTokenFactory trustedTokenFactory, BootstrapManager bootstrapManager, GateKeeper gateKeeper, VelocityHelperService velocityHelperService, OutboundWhitelist whitelist, RenderedContentCleaner contentCleaner) {
        super(localeManager, i18NBeanFactory, httpRetrievalService, trustedTokenFactory, whitelist);
        this.bootstrapManager = bootstrapManager;
        this.gateKeeper = gateKeeper;
        this.velocityHelperService = velocityHelperService;
        this.contentCleaner = contentCleaner;
    }

    private static byte[] readResponse(HttpResponse response) throws IOException {
        int read;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        InputStream in = response.getResponse();
        byte[] bytes = new byte[1024];
        while ((read = in.read(bytes)) != -1) {
            bytesOut.write(bytes, 0, read);
        }
        return bytesOut.toByteArray();
    }

    @Override
    protected String successfulResponse(Map<String, String> parameters, ConversionContext conversionContext, String url, HttpResponse response) throws MacroExecutionException {
        SyndFeed feed;
        int maxItems = TextUtils.parseInt((String)RenderUtils.getParameter(parameters, (String)"max", (int)1));
        String titleBar = TextUtils.noNull((String)RenderUtils.getParameter(parameters, (String)"titleBar", (int)2)).trim();
        boolean showTitlesOnly = TextUtils.parseBoolean((String)RenderUtils.getParameter(parameters, (String)"showTitlesOnly", (int)2));
        byte[] webContent = null;
        try {
            webContent = RssMacro.readResponse(response);
            feed = this.parseRSSFeed(url, webContent);
        }
        catch (IOException e) {
            if (webContent != null && response.getContentType().indexOf("html") != -1) {
                ByteArrayInputStream in = new ByteArrayInputStream(webContent);
                HtmlParserUtil tidy = new HtmlParserUtil(in){

                    protected void init(DOMFragmentParser parser) {
                    }
                };
                Node title = tidy.findTag("title");
                if (title != null) {
                    String titleString = tidy.getText(title);
                    throw new MacroExecutionException(this.getText("rss.error.reading-html-page-with-title", Arrays.asList(StringEscapeUtils.escapeHtml((String)titleString))));
                }
                throw new MacroExecutionException(this.getText("rss.error.reading-html-page"));
            }
            throw new MacroExecutionException(this.getText("rss.error.parse", Arrays.asList(e.toString())), (Throwable)e);
        }
        Map<String, Object> contextMap = this.getMacroVelocityContext();
        contextMap.put("url", url);
        contextMap.put("feed", feed);
        contextMap.put("max", maxItems);
        contextMap.put("showTitlesOnly", showTitlesOnly);
        contextMap.put("contentCleaner", this.contentCleaner);
        if (titleBar.equalsIgnoreCase("false") || titleBar.equalsIgnoreCase("no")) {
            contextMap.put("titleBar", "false");
        } else {
            contextMap.put("titleBar", "true");
        }
        try {
            return this.renderRssFeeds(contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to assemble the RSS result!", (Throwable)e);
            throw new MacroExecutionException(e.getMessage());
        }
    }

    @VisibleForTesting
    Map<String, Object> getMacroVelocityContext() {
        return this.velocityHelperService.createDefaultVelocityContext();
    }

    @VisibleForTesting
    String renderRssFeeds(Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate("com/atlassian/confluence/plugins/macros/html/rss.vm", contextMap);
    }

    private SyndFeed parseRSSFeed(String url, byte[] webContent) throws IOException {
        ByteArrayInputStream bufferedIn = new ByteArrayInputStream(webContent);
        try {
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)bufferedIn));
            return syndFeed;
        }
        catch (IOException ioe) {
            try {
                throw new FeedException("Unable to read XML from " + url, (Throwable)ioe);
            }
            catch (FeedException e) {
                String filename = "rssoutput" + url.hashCode() + ".txt";
                File rssParseError = new File(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"), filename);
                FileUtils.copyFile((InputStream)new ByteArrayInputStream(webContent), (File)rssParseError, (boolean)false);
                log.error("Error while trying to assemble the RSS result!", (Throwable)e);
                String path = "/download/temp/" + filename;
                this.gateKeeper.addKey(path, AuthenticatedUserThreadLocal.getUser());
                throw new IOException(e.getMessage() + " <a href='" + this.bootstrapManager.getWebAppContextPath() + path + "'>" + filename + "</a>");
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)bufferedIn);
        }
    }
}

