/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.html;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.macros.html.WhitelistedHttpRetrievalMacro;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.parser.HTMLPageParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;

public class HtmlIncludeMacro
extends WhitelistedHttpRetrievalMacro {
    private static final Logger logger = LoggerFactory.getLogger(HtmlIncludeMacro.class);
    private static final String DEFAULT_HTML_CHARSET = "ISO-8859-1";
    private static final Pattern CONTENT_TYPE_CHARSET_PATTERN = Pattern.compile("charset=\\s*?(.*)\\s*$");
    private static final Pattern HTML_TYPE_PATTERN = Pattern.compile("(?i)(content-type:\\s*?)?\\Qtext/html\\E.*$");

    public HtmlIncludeMacro(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, HttpRetrievalService httpRetrievalService, TrustedTokenFactory trustedTokenFactory, OutboundWhitelist whitelist) {
        super(localeManager, i18NBeanFactory, httpRetrievalService, trustedTokenFactory, whitelist);
    }

    private static String getContentTypeCharset(String contentTypeValue, InputStream httpInputStream) throws IOException {
        String contentTypeCharset = HtmlIncludeMacro.getContentTypeCharsetFromContenTypeValue(contentTypeValue);
        return null != contentTypeCharset ? contentTypeCharset : HtmlIncludeMacro.getContentTypeCharsetFromContenTypeValue(HtmlIncludeMacro.getContentTypeValueFromMetaTag(httpInputStream));
    }

    private static String getContentTypeCharsetFromContenTypeValue(String contentTypeValue) {
        Matcher matcher = CONTENT_TYPE_CHARSET_PATTERN.matcher(StringUtils.defaultString((String)contentTypeValue));
        return matcher.find() ? matcher.group(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContentTypeValueFromMetaTag(InputStream httpInputStream) throws IOException {
        String string;
        StringWriter errorWriter;
        block3: {
            errorWriter = null;
            try {
                String contentCharset;
                Tidy tidy = new Tidy();
                errorWriter = new StringWriter();
                tidy.setErrout(new PrintWriter(errorWriter));
                tidy.setQuiet(true);
                tidy.setForceOutput(true);
                tidy.setXHTML(true);
                Document document = new DOMReader().read(tidy.parseDOM(httpInputStream, null));
                Node contentTypeMetaNode = document.selectSingleNode("//head/meta[@http-equiv=\"Content-Type\"]/@content");
                string = contentCharset = null != contentTypeMetaNode ? contentTypeMetaNode.getText() : null;
                if (null == errorWriter) break block3;
            }
            catch (Throwable throwable) {
                if (null != errorWriter) {
                    logger.debug("Tidy errors: " + SystemUtils.LINE_SEPARATOR + ((Object)errorWriter).toString());
                }
                IOUtils.closeQuietly(errorWriter);
                throw throwable;
            }
            logger.debug("Tidy errors: " + SystemUtils.LINE_SEPARATOR + ((Object)errorWriter).toString());
        }
        IOUtils.closeQuietly((Writer)errorWriter);
        return string;
    }

    private static InputStream getResettableBufferedHttpInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
    }

    private static InputStreamReader getInputStreamReader(HttpResponse httpResponse, String userSpecifiedEncoding) throws IOException {
        InputStream httpResponseInputStream = HtmlIncludeMacro.getResettableBufferedHttpInputStream(httpResponse.getResponse());
        String contentTypeCharset = StringUtils.defaultString((String)userSpecifiedEncoding, (String)StringUtils.defaultString((String)HtmlIncludeMacro.getContentTypeCharset(httpResponse.getContentType(), httpResponseInputStream), (String)DEFAULT_HTML_CHARSET));
        try {
            httpResponseInputStream.reset();
            return new InputStreamReader(httpResponseInputStream, contentTypeCharset);
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(httpResponseInputStream, DEFAULT_HTML_CHARSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHttpResponseAsString(HttpResponse httpResponse, String userSpecifiedEncoding) throws IOException {
        String string;
        BufferedReader reader = null;
        StringWriter writer = null;
        try {
            reader = new BufferedReader(HtmlIncludeMacro.getInputStreamReader(httpResponse, userSpecifiedEncoding));
            writer = new StringWriter();
            IOUtils.copy((Reader)reader, (Writer)writer);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String successfulResponse(Map parameters, ConversionContext renderContext, String url, HttpResponse response) {
        String string;
        StringWriter writer = null;
        String contentType = StringUtils.defaultString((String)StringUtils.trim((String)response.getContentType()));
        if (!HTML_TYPE_PATTERN.matcher(contentType).matches()) {
            logger.debug("Content type is: " + contentType);
            return HtmlIncludeMacro.errorContent(this.getText("htmlinclude.error.content.type.not.supported", Arrays.asList(url)));
        }
        try {
            HTMLPageParser parser = new HTMLPageParser();
            Page siteMeshPage = parser.parse(HtmlIncludeMacro.getHttpResponseAsString(response, (String)parameters.get("encoding")).toCharArray());
            writer = new StringWriter();
            siteMeshPage.writeBody((Writer)writer);
            string = ((Object)writer).toString();
        }
        catch (IOException ioe) {
            String string2;
            try {
                logger.error("IOException occured while parsing: " + url, (Throwable)ioe);
                string2 = HtmlIncludeMacro.errorContent(ioe.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return string2;
        }
        IOUtils.closeQuietly((Writer)writer);
        return string;
    }

    private static String errorContent(String message) {
        return "<span class=\"error\">" + StringEscapeUtils.escapeHtml((String)message) + "</span>";
    }
}

