var confluenceBaseUrl = $('#confluence-context-path').attr('content');
// Make sure confluenceBaseUrl starts and ends with a '/'.
if (confluenceBaseUrl) {
    if (!confluenceBaseUrl.startsWith('/')) {
        confluenceBaseUrl = '/' + confluenceBaseUrl;
    }
    if (!confluenceBaseUrl.endsWith('/')) {
        confluenceBaseUrl = confluenceBaseUrl + '/';
    }
} else {
    confluenceBaseUrl = '/';
}
var confluenceBasePath = null;
var confluenceUserAuthenticationRelativePath = 'plugins/servlet/hipchat/user-authentication';
var confluenceUserAuthenticationUrl = confluenceBaseUrl + confluenceUserAuthenticationRelativePath;

// Message severity constants.
var INFO_SEVERITY = 'info';
var ERROR_SEVERITY = 'error';
var SUCCESS_SEVERITY = 'success';

// Default values for presenting messages.
var NO_ACTION_TEXT = null;
var NO_ACTION_FUNCTION = null;
var STANDARD_AUTO_HIDE_DELAY_MILLISECONDS = 5000;

var SESSION_UPDATE_PERIOD_MILLISECONDS = 30000;

var trueValue = 'true';
var startOauthKey = 'in-confluence-to-start-oauth';
var oauthCompletedKey = 'oauth-complete';
var jwtTokenKey = 'jwt-token';
var loginPanelSelector = '#login-form';
var oauthCompletedPanelSelector = '#oauth-completed';
var loggedInContentSelector = '#logged-in-content';
var errorResponseSelector = '#error-response';
var loadingSelector = '#loading-content';
var allPanelSelectors = [loginPanelSelector, oauthCompletedPanelSelector, loggedInContentSelector, errorResponseSelector, loadingSelector];
var webpanelConfig = {};
var hipChatContext = {};
var currentMessageAction = null;
var defaultMaxItems = 20;

function initialiseConfig() {
    var pluginKey = "com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin";
    var resourceKey = "confluence-webpanel-data-resources";
    var providerKey = "webpanel-data";
    var wrmData = WRM.data instanceof Function ? WRM.data : WRM.data.claim;
    var injectedData = wrmData(pluginKey + ":" + resourceKey + "." + providerKey);
    webpanelConfig = {
        session: {
            id: createGuid(),
            startTime: Date.now(),
            dataGroupChangeCount: 0,
            dataGroupSubselectChangeCount: 0
        },
        ALL_MAPPED_SPACES_FILTER: injectedData.allMappedSpacesFilter,
        SPACE_TO_ROOM_MAPPING_UPDATE_EVENT_TYPE: injectedData.spaceToRoomMappingUpdateEventTypeKey,
        SIDEBAR_DISABLED_EVENT_TYPE: injectedData.sidebarDisabledEventTypeKey,
        SHARE_FAILURE_EVENT_TYPE: injectedData.shareFailureEventTypeKey,
        AUTHENTICATION_COMPLETE_EVENT_TYPE: injectedData.authenticationCompleteEventTypeKey,
        USER_PERMISSION_CHANGED_EVENT_TYPE: injectedData.userPermissionChangedEventTypeKey,
        CONTENT_CHANGED_EVENT_TYPE: injectedData.contentChangedEventTypeKey,
        CONTENT_VIEWED_EVENT_TYPE: injectedData.contentViewedEventTypeKey,
        documentsImageUrl: injectedData.documentsImageUrl,
        feedbackLinkUrl: injectedData.feedbackLinkUrl,
        MY_WORK_TYPES: [
            {typeName: 'All', label: AJS.I18n.getText("confluence.plugins.hipchat.webpanel.workType.all")},
            {typeName: 'MENTIONED_IN', label: AJS.I18n.getText("confluence.plugins.hipchat.webpanel.workType.mentionedIn")},
            {typeName: 'RECENTLY_WORKED_ON', label: AJS.I18n.getText("confluence.plugins.hipchat.webpanel.workType.recentlyWorkedOn")},
            {typeName: 'RECENTLY_VISITED', label: AJS.I18n.getText("confluence.plugins.hipchat.webpanel.workType.recentlyVisited")},
            {typeName: 'SAVED_FOR_LATER', label: AJS.I18n.getText("confluence.plugins.hipchat.webpanel.workType.savedForLater")}
        ],
        //userContext: {},
        showingNewContentRefreshAlert: false,
        currentMessageId: null,
        lastSelectedMyWorkTypeName: 'ALL',
        contentGroupsToConfigs: {
            'updates': {
                'analytics-id': 'updates',
                enabled: false,
                contentRestrictedToMappedSpaces: true,
                'query-builder': spaceFilterableQueryBuilder,
                'space-filter-element-id': 'updates-space-selector',
                'query-path': 'updates',
                'max-items': defaultMaxItems,
                'result-selector': '#updates-content-items'
            }, 'mentioned': {
                'analytics-id': 'mentioned',
                enabled: false,
                contentRestrictedToMappedSpaces: true,
                'query-builder': defaultQueryBuilder,
                'query-path': 'mentioned',
                'max-items': defaultMaxItems,
                'result-selector': '#mentioned-content-items'
            }, 'my-work': {
                'analytics-id': 'my-work',
                enabled: false,
                contentRestrictedToMappedSpaces: false,
                'query-builder': myWorkQueryBuilder,
                'my-work-type-selector-element-id': 'my-work-type-selector',
                'query-path': 'my-work',
                'max-items': defaultMaxItems,
                'result-selector': '#my-work-content-items'
            }
        }
    };
}

function getConfluenceBasePath() {
    if (!confluenceBasePath) {
        var a = document.createElement("a");
        a.href = confluenceBaseUrl;
        confluenceBasePath = a.pathname;
    }
    return confluenceBasePath;
}

function login() {

}

function handleLogoffRequest(event) {
    HipChat.auth.withToken(function(error, token) {
        if (error) {
            presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.unableToEstablishCredentials"));
            handleNotSignedIn();
        } else {
            var url = confluenceBaseUrl + 'rest/hipchat/spacetoroom/latest/connect-api/logoff?signed_request=' + token;
            var postData = {
                url: url,
                dataType: 'json',
                headers: { 'X-Atlassian-Token': 'no-check' },
                type: 'POST'
            };
            $.ajax(postData).done(function() {
                hideRefreshContentAlert();
                handleNotSignedIn();
            }).fail(function(jqXHR, textStatus) {
                if (jqXHR && jqXHR.status == 401) {
                    // a normal authentication error
                } else if (jqXHR && jqXHR.status == 406) {
                    presentInfo(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.invalidHipChatToken"));
                } else {
                    presentError(AJS.I18n.getText('confluence.plugins.hipchat.webpanel.errorWhileLoggingOff') + textStatus);
                }
                handleNotSignedIn();
            });
        }
        sendAnalyticsEvent('confluence.hipchat.connect.sidebar.disconnect.click', {});
    });
    event.preventDefault();
}

function getSelectedGroupConfig() {
    var hash = location.hash;
    if (hash) {
        var contentGroup = hash.replace('-tab', '').replace('#', '');
        var config = webpanelConfig.contentGroupsToConfigs[contentGroup];
        return config;
    } else {
        return getFirstEnabledGroup();
    }
}

function getFirstEnabledGroup() {
    for (var groupKey in webpanelConfig.contentGroupsToConfigs) {
        var tabConfig = webpanelConfig.contentGroupsToConfigs[groupKey];
        if (tabConfig.enabled) {
            return tabConfig;
        }
    }
    presentError(AJS.I18n.getText('confluence.plugins.hipchat.webpanel.noEnabledGroups'));
    return null;
}

function getWebpanelData() {
    var tabConfig = getSelectedGroupConfig();
    HipChat.auth.withToken(function(error, token) {
        if (error) {
            presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.unableToEstablishCredentials"));
            handleNotSignedIn();
        } else {
            getWebpanelDataWithToken(token, tabConfig);
        }
    });
}

function getWebpanelDataWithToken(token, tabConfig) {
    var queryParametersBuilder = tabConfig['query-builder'];
    var queryParameters = queryParametersBuilder(token, tabConfig);
    var url = confluenceBaseUrl + 'rest/hipchat/spacetoroom/latest/connect-api/' + queryParameters.query;
    showPanel(loadingSelector);
    var responseStatus;
    $.ajax({
        type: 'GET',
        url: url,
        cache: false
    }).done(function(contentResult) {
        setResult(contentResult, tabConfig, queryParameters.selectedSpaceFilter);
        showPanel(loggedInContentSelector);
        responseStatus = "OK";
        hideRefreshContentAlert();
    }).fail(function(jqXHR, textStatus) {
        if (jqXHR && jqXHR.status == 401) {
            responseStatus = "AuthenticationError";
            handleNotSignedIn();
        } else if (jqXHR && jqXHR.status == 406) {
            presentInfo(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.invalidHipChatToken"));
            responseStatus = "AuthenticationError";
            handleNotSignedIn();
        } else {
            responseStatus = "Fail";
            handleConfluenceDataPullError()
        }
    }).always(function(){
        sendAnalyticsEvent('confluence.hipchat.connect.sidebar.data.pull', {
            dataGroupName: tabConfig['analytics-id'],
            responseStatus: responseStatus
        });
    });
}

function myWorkQueryBuilder(token, tabConfig) {
    var myWorkTypeSelectorElementId = tabConfig['my-work-type-selector-element-id'];
    var $myWorkTypeSelector = $('#' + myWorkTypeSelectorElementId);
    var myWorkType = 'ALL';
    if ($myWorkTypeSelector && $myWorkTypeSelector.length) {
        var $selectedOption = $('#' + myWorkTypeSelectorElementId + ' option:selected');
        if ($selectedOption && $selectedOption.length) {
            myWorkType = $selectedOption.attr('myWorkTypeName');
        }
    }
    var queryPath = tabConfig['query-path'];
    var maxItems = tabConfig['max-items'];
    return {
        selectedSpaceFilter: webpanelConfig.ALL_MAPPED_SPACES_FILTER,
        query: queryPath + '/' + myWorkType + '/' + maxItems + '?signed_request=' + token,
    };
}

function spaceFilterableQueryBuilder(token, tabConfig) {
    var spaceFilterElementId = tabConfig['space-filter-element-id'];
    var $spaceFilter = $('#' + spaceFilterElementId);
    if ($spaceFilter && $spaceFilter.length) {
        var $selectedOption = $('#' + spaceFilterElementId + ' option:selected');
        if ($selectedOption && $selectedOption.length) {
            var allSpacesOption = $selectedOption.attr('allSpaces');
            if (allSpacesOption === 'true') {
                var spaceFilter = webpanelConfig.ALL_MAPPED_SPACES_FILTER;
            } else {
                var spaceFilter = $selectedOption.attr('spaceKey');
            }
        } else {
            var spaceFilter = webpanelConfig.ALL_MAPPED_SPACES_FILTER;
        }
    } else {
        var spaceFilter = webpanelConfig.ALL_MAPPED_SPACES_FILTER;
    }
    var queryPath = tabConfig['query-path'];
    var maxItems = tabConfig['max-items'];
    return {
        selectedSpaceFilter: spaceFilter,
        query: queryPath + '/' + spaceFilter + '/' + maxItems + '?signed_request=' + token,
    };
}

function defaultQueryBuilder(token, tabConfig) {
    var queryPath = tabConfig['query-path'];
    var maxItems = tabConfig['max-items'];
    return {
        selectedSpaceFilter: webpanelConfig.ALL_MAPPED_SPACES_FILTER,
        query: queryPath + '/' + maxItems + '?signed_request=' + token,
    };
}

function setResult(contentResult, tabConfig, selectedSpaceFilter) {
    clearPreviousResults();

    var resultSelector = tabConfig['result-selector'];
    var $section = $(resultSelector);

    buildMyWorkTypeSelector(tabConfig);
    buildSpaceSelector(contentResult, tabConfig, selectedSpaceFilter);
    if (contentResult && contentResult.items && contentResult.items.length) {
        var showSpaceName = !tabConfig.contentRestrictedToMappedSpaces || areMultipleSpacesMapped(contentResult);
        var $ol = $('<ol/>', {
            'class': 'aui-connect-list'
        });
        $ol.appendTo($section);
        for (var index = 0; index < contentResult.items.length; index++) {
            var item = contentResult.items[index];
            appendItem($ol, item, showSpaceName);
        }
    } else {
        buildEmptryResultsContent($section);
    }
}

function clearPreviousResults() {
    // Note that this routine clears results from all sections because it has been observed that
    // the contextual menu is dynamically built by AUI which can cause rendering problems if
    // not cleaned up.
    for (var groupKey in webpanelConfig.contentGroupsToConfigs) {
        var tabConfig = webpanelConfig.contentGroupsToConfigs[groupKey];
        if (tabConfig.enabled) {
            var resultSelector = tabConfig['result-selector'];
            var $section = $(resultSelector);
            $section.empty();
        }
    }
}

function buildEmptryResultsContent($section) {
    var $focusedSection = $('<div/>', {
        'class': 'focused-content aui-connect-page-focused'
    });
    var $content = $('<div/>', {
        'class': 'aui-connect-content'
    });
    var $contentInner = $('<div/>', {
        'class': 'aui-connect-content-inner'
    });
    var $img = $('<img/>', {
        'class': 'aui-connect-list content-image',
        'src': webpanelConfig.documentsImageUrl
    });
    $focusedSection.appendTo($section);
    $content.appendTo($focusedSection);
    $contentInner.appendTo($content);
    $img.appendTo($contentInner);

    var $header = $('<p/>', {
        'class': 'content-header',
        'text': AJS.I18n.getText("confluence.plugins.hipchat.webpanel.nothingToSee")
    });
    var $caption = $('<p/>', {
        'class': 'content-caption',
        'text': AJS.I18n.getText("confluence.plugins.hipchat.webpanel.checkBackLater")
    });
    $header.appendTo($contentInner);
    $caption.appendTo($contentInner);
}

function buildMyWorkTypeSelector(tabConfig) {
    var myWorkTypeSelectorElementId = tabConfig['my-work-type-selector-element-id'];
    var $myWorkTypeSelector = $('#' + myWorkTypeSelectorElementId);
    if ($myWorkTypeSelector && $myWorkTypeSelector.length) {
        $myWorkTypeSelector.unbind('change');
        var myWorkTypes = webpanelConfig.MY_WORK_TYPES;
        $myWorkTypeSelector.empty();
        for (var index = 0; index < myWorkTypes.length; index++) {
            var myWorkType = myWorkTypes[index];
            var $option = $('<option/>', {
                'myWorkTypeName': myWorkType.typeName,
                'text': myWorkType.label
            });
            if (myWorkType.typeName === webpanelConfig.lastSelectedMyWorkTypeName) {
                $option.prop('selected', true);
            }
            $option.appendTo($myWorkTypeSelector);
        }
        $myWorkTypeSelector.removeClass('hidden');
        $myWorkTypeSelector.change(function() {
            var $selectedOption = $('#' + myWorkTypeSelectorElementId + ' option:selected');
            if ($selectedOption && $selectedOption.length) {
                webpanelConfig.lastSelectedMyWorkTypeName = $selectedOption.attr('myWorkTypeName');
                webpanelConfig.session.dataGroupSubselectChangeCount++;
                getWebpanelData();
            }
        });
        blurAfterRender($myWorkTypeSelector);
    }
}

function buildSpaceSelector(contentResult, tabConfig, selectedSpaceFilter) {
    var spaceSelectorElementId = tabConfig['space-filter-element-id'];
    var $spaceSelector = $('#' + spaceSelectorElementId);
    if ($spaceSelector && $spaceSelector.length) {
        $spaceSelector.unbind('change');
        if (areMultipleSpacesMapped(contentResult)) {
            $spaceSelector.empty();
            var $option = $('<option/>', {
                'allSpaces': true,
                'text': 'All'
            });
            $option.appendTo($spaceSelector);
            for (var index = 0; index < contentResult.mappedSpaces.length; index++) {
                var mappedSpace = contentResult.mappedSpaces[index];
                var $option = $('<option/>', {
                    'allSpaces': false,
                    'spaceKey': mappedSpace.spaceKey,
                    'text': mappedSpace.spaceName
                });
                if (selectedSpaceFilter && selectedSpaceFilter === mappedSpace.spaceKey) {
                    $option.prop('selected', true);
                }
                $option.appendTo($spaceSelector);
            }
            $spaceSelector.removeClass('hidden');
            $spaceSelector.change(function() {
                webpanelConfig.session.dataGroupSubselectChangeCount++;
                getWebpanelData();
            });
        } else {
            $spaceSelector.addClass('hidden');
        }
        blurAfterRender($spaceSelector);
    }
}

function areMultipleSpacesMapped(contentResult) {
    return contentResult.mappedSpaces && contentResult.mappedSpaces.length && contentResult.mappedSpaces.length > 1;
}

function blurAfterRender($focussable) {
    setTimeout(function() {
        $focussable.blur();
    }, 1);
}

function appendItem($ol, item, showSpaceName) {
    if (item.url) {
        appendLinkItem($ol, item.level, item.type, item.contentId, item.title, item.url,
            item.changeType, item.excerpt, item.spaceName, item.updatedTimestamp, showSpaceName);
    } else {
        appendHeaderItem($ol, item.level, item.title);
    }
}

function appendHeaderItem($ol, level, title) {
    var $li = $('<li/>', {
        'class': 'aui-connect-list-item'
    });
    var $headerContent = $('<span>', {
        'class': 'list-item-header-' + level,
        'text': title
    });
    $li.appendTo($ol);
    $headerContent.appendTo($li);
    return $li;
}

function appendLinkItem($ol, level, itemType, contentId, title, url, changeType, excerpt, spaceName, updatedTimestamp, showSpaceName) {
    if (itemType === 'page') {
        var iconClass = 'aui-iconfont-page-default';
        var contentClickHandler = pageClickHandler;
    } else if (itemType === 'blog' || itemType === 'blogpost') {
        var iconClass = 'aui-iconfont-page-blogpost';
        var contentClickHandler = blogClickHandler;
    } else if (itemType === 'comment') {
        var iconClass = 'aui-iconfont-comment';
        var contentClickHandler = commentClickHandler;
    } else {
        var iconClass = 'aui-iconfont-editor-help';
        var contentClickHandler = otherContentClickHandler;
    }
    var $li = $('<li/>', {
        'class': 'aui-connect-list-item list-item-link-' + level
    });
    var $header = $('<div/>', {
        'class': 'aui-connect-list-item-header'
    });
    var $avatar = $('<span/>', {
        'class': 'aui-avatar aui-avatar-xsmall'
    });
    var $avatarInner = $('<span/>', {
        'class': 'aui-avatar-inner'
    });
    var $icon = $('<span/>', {
        'class': 'aui-icon aui-icon-small ' + iconClass
    });
    var $link = $('<a/>', {
        'class': 'aui-connect-list-item-title',
        'href' : url,
        'target': '_blank',
        'title': title,
        'text': title
    });
    $link.click(contentClickHandler);
    var $attributes = $('<ul/>', {
        'class': 'aui-connect-list-item-attributes'
    });

    $li.appendTo($ol);
    $header.appendTo($li);
    $avatar.appendTo($header);
    $avatarInner.appendTo($avatar);
    $icon.appendTo($avatarInner);
    $link.appendTo($header);
    $attributes.appendTo($li);
    if (changeType) {
        var $changeType = $('<li/>', {
            'text': changeType
        });
        $changeType.appendTo($attributes);
    }
    if (updatedTimestamp) {
        var updateTime = new Date(updatedTimestamp);
        var formattedUpdateTime = updateTime.toLocaleDateString();
        var $updated = $('<li/>', {
            'text': formattedUpdateTime
        });
        $updated.appendTo($attributes);
    }
    if (showSpaceName && spaceName) {
        var $spaceInfo = $('<div/>', {
            'class': 'space-info aui-connect-list-item-description'
        });
        var $spaceLabel = $('<span/>', {
            'class': 'space-label',
            'text': AJS.I18n.getText("confluence.plugins.hipchat.glance.space.label")
        });
        var $spaceName = $('<span/>', {
            'class': 'space-name',
            'text': spaceName
        });
        $spaceLabel.appendTo($spaceInfo);
        $spaceName.appendTo($spaceInfo);
        $spaceInfo.appendTo($li);
    }
    if (excerpt) {
        excerpt = $.trim(excerpt);
    }
    if (excerpt) {
        var $excerpt = $('<div/>', {
            'class': 'list-item-description aui-connect-list-item-description',
            'text': excerpt
        });
        $excerpt.appendTo($li);
    }
    if (contentId) {
        addActions(contentId, itemType, $li)
    }
    return $li;
}

function addActions(contentId, itemType, $li) {
    var actionItemsContainerId = 'list-menu-items-' + contentId;
    var $actionsContainer = $('<div/>', {
        'class': 'aui-connect-list-item-actions'
    });
    var $actionsButton = $('<button/>', {
        'id': 'list-action-menu-' + contentId,
        'class': 'aui-dropdown2-trigger aui-button aui-dropdown2-trigger-arrowless',
        'aria-owns' : actionItemsContainerId,
        'aria-haspopup': 'true',
        'data-no-focus': true
    });
    var $moreSpan = $('<span/>', {
        'class': 'aui-icon aui-icon-small aui-iconfont-more'
    });
    var $actionItemsContainer = $('<div/>', {
        'id': actionItemsContainerId,
        'class': 'aui-style-default aui-dropdown2 aui-connect-list-item-action'
    });
    var $actionItemsList = $('<ul/>', {
        'class': 'aui-list-truncate'
    });
    var $actionItem = $('<li/>', {
        'data-content-id': contentId
    });
    var $action = $('<a/>', {
        'href' : '#',
        'text': AJS.I18n.getText('confluence.plugins.hipchat.webpanel.shareToRoom')
    });
    $actionItem.click(function(event) {
        handleShareToRoomRequest(event, itemType);
    });
    $moreSpan.appendTo($actionsButton);
    $actionsButton.appendTo($actionsContainer);
    $action.appendTo($actionItem);
    $actionItem.appendTo($actionItemsList);
    $actionItemsList.appendTo($actionItemsContainer);
    $actionItemsContainer.appendTo($actionsContainer);
    $actionsContainer.appendTo($li);
}

function handleShareToRoomRequest(event, itemType) {
    var contentId = getContentIdFromNode(event.target);
    if (!contentId) {
        contentId = getContentIdFromNode(event.target.parentNode);
    }
    if (contentId) {
        HipChat.auth.withToken(function(error, jwtToken) {
            if (error) {
                presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.unableToEstablishCredentials"));
                handleNotSignedIn();
            } else {
                var groupConfig = getSelectedGroupConfig();
                var postData = {
                    url: confluenceBaseUrl + 'rest/hipchat/spacetoroom/latest/connect-api/share-content-to-room?signed_request=' + jwtToken,
                    type: "POST",
                    dataType: 'json',
                    contentType: 'application/json',
                    data: JSON.stringify({
                        'contentId': contentId
                    })
                };
                var responseStatus = '';
                $.ajax(postData).done(function() {
                    responseStatus = 'OK';
                }).fail(function(jqXHR, textStatus) {
                    if (jqXHR.status == 404) {
                        responseStatus = "Not found";
                        presentInfo(
                                AJS.I18n.getText("confluence.plugins.hipchat.webpanel.notSharedBecauseDeleted"),
                                AJS.I18n.getText("confluence.plugins.hipchat.webpanel.actionText.refresh"),
                                getWebpanelData);
                    } else {
                        responseStatus = "Fail";
                        presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.errorWhileSharing") + textStatus);
                    }
                }).always(function() {
                    sendAnalyticsEvent('confluence.hipchat.connect.sidebar.content.share', {
                        dataGroupName: groupConfig['analytics-id'],
                        responseStatus: responseStatus,
                        contentType: itemType
                    });
                });
            }
        });
    }
    event.preventDefault();
}

function getContentIdFromNode(node) {
    if (node && node.dataset) {
        return node.dataset.contentId;
    } else {
        return null;
    }
}

function showPanel(panelSelector) {
    for (var index = 0; index < allPanelSelectors.length; index++) {
        var selector = allPanelSelectors[index];
        if (selector === panelSelector) {
            showBlock(selector);
        } else {
            hideBlock(selector);
        }
    }
}

function getCurrentPanelId() {
    for (var index = 0; index < allPanelSelectors.length; index++) {
        var selector = allPanelSelectors[index];
        var $elements = $(selector);
        if ($elements.is(':visible')) {
            return selector.replace('#', '');
        }
    }
    return 'none';
}

function showBlock(selector) {
    var $elements = $(selector);
    $elements.removeClass("hidden");
    $elements.addClass("visible-block");
}

function hideBlock(selector) {
    var $elements = $(selector);
    $elements.removeClass("visible-block");
    $elements.addClass("hidden");
}

function updateTabSelection() {
    selectTabByHash(location.hash);
}

function selectTabByHash(hash) {
    $('.aui-nav li').each(function () {
        var selected = $(this).find('a').attr('href') === hash;
        $(this).toggleClass('aui-nav-selected', selected);
    });
}

$(document).ready(function() {
    try {
        setTheme();
        initialiseConfig();
        if (location.hash) {
            updateTabSelection();
        }
        $('#search-button').click(getWebpanelData);
        $("#login-button").click(login);
        $("#logoff-button").click(handleLogoffRequest);
        $("#close-compact-message-container").click(closeMessage);
        $("#loading-content-spinner").spin();
        $('#message-action').click(handleMessageAction);

        if (inSidebar()) {
            // Subscribing to glance updates allows us to receive the trigger from the Confluence full frame indicating
            // the oAuth dance is complete.
            subscribeToGlanceUpdates();
            periodicallySendSessionUpdates();
        }
        initialise();
    } catch (e) {
        presentError('ERROR: ' + e);
    }
});

function setTheme() {
    var theme = getQueryVariable('theme');
    if (theme === 'light' || theme === 'dark') {
        $('body').addClass(theme);
    }
}

function bootstrapUi(uiContext) {
    var contentGroupsToConfigs = webpanelConfig.contentGroupsToConfigs;
    contentGroupsToConfigs['updates'].enabled = uiContext.updatesTabEnabled;
    contentGroupsToConfigs['mentioned'].enabled = uiContext.mentionedTabEnabled;
    contentGroupsToConfigs['my-work'].enabled = uiContext.myWorkTabEnabled;

    var firstEnabledGroupKey = null;
    for (var groupKey in contentGroupsToConfigs) {
        var tabConfig = contentGroupsToConfigs[groupKey];
        if (tabConfig.enabled) {
            if (firstEnabledGroupKey == null) {
                firstEnabledGroupKey = groupKey;
            }
        } else {
            $('#' + groupKey + '-tab').remove();
            $('#' + groupKey + '-tab-item').remove();
            $('#' + groupKey + '-content').remove();
        }
    }
    if (firstEnabledGroupKey) {
        selectTabByHash('#' + firstEnabledGroupKey + '-tab');
    }

    if (webpanelConfig.feedbackLinkUrl) {
        $('#feedback-link').attr('href', webpanelConfig.feedbackLinkUrl);;
        $('#feedback-link').removeClass('hidden');;
        $('#feedback-link-separator').removeClass('hidden');
    }
}

function inSidebar() {
    var inSidebar = typeof HipChat !== 'undefined';
    return inSidebar;
}

function initialise() {
    if (inSidebar()) {
        HipChat.auth.withToken(function(error, jwtToken) {
            if (error) {
                presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.unableToEstablishCredentials"));
                handleNotSignedIn();
            } else {
                hipChatContext = {
                    inSidebar: false,
                    jwtToken: jwtToken
                };
                finishInitialisation(jwtToken);
            }
        });


    } else {
        var jwtToken = getQueryVariable(jwtTokenKey);
        hipChatContext = {
            inSidebar: false,
            jwtToken: jwtToken
        };
        finishInitialisation(jwtToken);
    }
}

function finishInitialisation(jwtToken) {
    var href = confluenceUserAuthenticationUrl + '?' + startOauthKey + '=' + trueValue + '&' + jwtTokenKey + '=' + hipChatContext.jwtToken;
    $('#authenticate-user').attr('href', href);

    var oauthCompleted = getQueryVariable(oauthCompletedKey);
    if (oauthCompleted == trueValue) {
        // We're in a full window within Confluence following the return from HipChat to oAuth the user.
        handleOauthCompleted();
    } else {
        var doStartOauth = getQueryVariable(startOauthKey);
        if (doStartOauth == trueValue) {
            // We're in a full window to Confluence so we can start the Oauth to HipChat in order to map the Confluence/HipChat users.
            startOauth();
        } else {
            loadInitialContextAndCompleteInitialisation(jwtToken);
        }
    }
}

function loadInitialContextAndCompleteInitialisation(jwtToken) {
    var url = confluenceBaseUrl + 'rest/hipchat/spacetoroom/latest/connect-api/get-initial-context/' + defaultMaxItems + '?signed_request=' + jwtToken;
    showPanel(loadingSelector);
    $.ajax({
        type: 'GET',
        url: url,
        cache: false
    }).done(function(initialContext) {
        bootstrapUi(initialContext.uiContext);
        if (initialContext.confluenceHipChatUserMapped) {
            var tabConfig = getFirstEnabledGroup();
            var selectedSpaceFilter = null;
            setResult(initialContext.contentResult, tabConfig, selectedSpaceFilter);
            showPanel(loggedInContentSelector);
        } else {
            handleNotSignedIn();
        }
    }).fail(function(jqXHR, textStatus) {
        handleNotSignedIn();
    });
}

function handleNotSignedIn() {
    // This will be reached only in an iframe within HipChat. In this case, we present the login panel which shows
    // a button requesting the user login. Clicking this button will take the user to Confluence allowing them to
    // start the oauth dance with HipChat.
    showPanel(loginPanelSelector);
}

function handleConfluenceDataPullError() {
    showPanel(errorResponseSelector);
    var $retryButton = $('#retry-content-pull');
    $retryButton.unbind('click');
    $retryButton.click(function(event) {
        showPanel(loggedInContentSelector);
        closeMessage();
        getWebpanelData();
        event.preventDefault();
    });
}


function subscribeToGlanceUpdates() {
    HipChat.register({
        "glance-update": function(data) {
            // Don't refresh the content automatically because:
            // (a) this would be disruptive to a user who is viewing the list of items; and
            // (b) this will create spikes in the Confluence requests.
            if (data) {
                if (data.metadata) {
                    var eventType = data.metadata['event-type'];
                    if (eventType) {
                        if (eventType == webpanelConfig.SPACE_TO_ROOM_MAPPING_UPDATE_EVENT_TYPE) {
                            if (isShowingLoggedInContent()) {
                                presentNewContentAlert();
                            }
                        } else if (eventType == webpanelConfig.SIDEBAR_DISABLED_EVENT_TYPE) {
                            HipChat.sidebar.closeView();
                        } else if (eventType == webpanelConfig.SHARE_FAILURE_EVENT_TYPE) {
                            presentShareFailureAlert();
                        } else if (eventType == webpanelConfig.AUTHENTICATION_COMPLETE_EVENT_TYPE) {
                            presentSuccess(AJS.I18n.getText(
                                    "confluence.plugins.hipchat.webpanel.loggedIn"),
                                    NO_ACTION_TEXT,
                                    NO_ACTION_FUNCTION,
                                    STANDARD_AUTO_HIDE_DELAY_MILLISECONDS);
                            getWebpanelData();
                        } else {
                            if (isShowingLoggedInContent()) {
                                var tabConfig = getSelectedGroupConfig();
                                if (eventType == webpanelConfig.CONTENT_CHANGED_EVENT_TYPE && tabConfig == webpanelConfig.contentGroupsToConfigs['updates']) {
                                    presentNewContentAlert();
                                } else if (eventType == webpanelConfig.CONTENT_VIEWED_EVENT_TYPE && tabConfig == webpanelConfig.contentGroupsToConfigs['my-work']) {
                                    presentNewContentAlert();
                                } else if (eventType == webpanelConfig.USER_PERMISSION_CHANGED_EVENT_TYPE) {
                                    // These events are targeted to specific users and are generally more rare. Since they are quite important
                                    // they deserve an immediate refresh to ensure the user is viewing content available to them.
                                }
                            }
                        }
                    } else {
                        presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.noEventType"));
                    }
                } else {
                    presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.noMetadata"));
                }
            } else {
                presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.noData"));
            }
        }
    });
}

function isShowingLoggedInContent() {
    return $(loggedInContentSelector).is(":visible");
}

function startOauth() {
    // This will be reached only in a full frame within Confluence.
    showPanel(loadingSelector);
    var redirectQuery = oauthCompletedKey + '=' + trueValue + "&" + jwtTokenKey + '=' + hipChatContext.jwtToken;
    var postData = {
        url: getConfluenceBasePath() + 'rest/hipchat/integration/latest/oauth2/begin',
        type: "POST",
        dataType: 'json',
        contentType: 'application/json',
        data: JSON.stringify({
            redirect: confluenceUserAuthenticationRelativePath,
            redirectQuery: redirectQuery,
            redirectFragment: ''
        })
    };
    $.ajax(postData).done(handleOauthRequested).fail(function(jqXHR, textStatus) {
        presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.errorAuthenticating") + textStatus);
    });
    sendAnalyticsEvent('confluence.hipchat.connect.sidebar.oauth.started', {});
}

function handleOauthCompleted() {
    showPanel(oauthCompletedPanelSelector);
    setOauthCompletionStatus(
        AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.success.title'),
        AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.success.message.status'),
        AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.success.message.instructions'),
        true);
    var jwtToken = getQueryVariable(jwtTokenKey);
    var url = confluenceBaseUrl + 'rest/hipchat/spacetoroom/latest/connect-api/signal-user-oauth-complete?signed_request=' + jwtToken;
    var postData = {
        url: url,
        dataType: 'json',
        headers: { 'X-Atlassian-Token': 'no-check' },
        type: "POST"
    };
    $.ajax(postData).done(function() {
        showPanel(oauthCompletedPanelSelector);
    }).fail(function(jqXHR, textStatus) {
        if (jqXHR.status == 401) {
            // The JWT token is invalid. This is most likely caused by the validity of the token expiring.
            setOauthCompletionStatus(
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.timeout.title'),
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.timeout.message.status', textStatus),
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.timeout.message.instructions'),
                false);
        } else {
            setOauthCompletionStatus(
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.error.title'),
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.error.message.status', textStatus),
                AJS.I18n.getText('confluence.plugins.hipchat.glance.oauth.completed.error.message.instructions'),
                false);
        }
    });
}

function setOauthCompletionStatus(title, message, instructions, isSuccess) {
    var $header = $('#oauth-completed-header');
    var $messageDiv = $('.oauth-completed-message');
    var $icon = $('#oauth-completed-icon');
    var $message = $('#oauth-completed-status-message');
    var $instructions = $('#oauth-completed-instructions');

    $header.text(title);
    $message.text(message);
    $instructions.text(instructions);

    if (isSuccess) {
        $messageDiv.removeClass('oauth-completed-error');
        $messageDiv.addClass('oauth-completed-success');
        $icon.removeClass('aui-iconfont-error');
        $icon.addClass('aui-iconfont-approve');
    } else {
        $messageDiv.removeClass('oauth-completed-success');
        $messageDiv.addClass('oauth-completed-error');
        $icon.removeClass('aui-iconfont-approve');
        $icon.addClass('aui-iconfont-error');
    }
}

function handleOauthRequested(hipchatOauthUri) {
    window.location = hipchatOauthUri;
}

function getQueryVariable(variable) {
    var query = window.location.search.substring(1);
    var vars = query.split("&");
    for (var i=0;i<vars.length;i++) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) {
            return pair[1];
        }
    }
    return false;
}

function hideRefreshContentAlert() {
    if (webpanelConfig.showingNewContentRefreshAlert) {
        closeMessage();
        webpanelConfig.showingNewContentRefreshAlert = false;
    }
}

function presentNewContentAlert() {
    presentInfo(
            AJS.I18n.getText("confluence.plugins.hipchat.webpanel.newContent"),
            AJS.I18n.getText("confluence.plugins.hipchat.webpanel.actionText.refresh"),
            getWebpanelData);
    webpanelConfig.showingNewContentRefreshAlert = true;
}

function presentShareFailureAlert() {
    presentError(AJS.I18n.getText("confluence.plugins.hipchat.webpanel.notSharedAccessRestriction"));
}

function presentError(message, actionText, actionFunction, autoHideDelayMillis) {
    presentMessage(ERROR_SEVERITY, message, actionText, actionFunction, autoHideDelayMillis);
    webpanelConfig.showingNewContentRefreshAlert = false;
}

function presentInfo(message, actionText, actionFunction, autoHideDelayMillis) {
    presentMessage(INFO_SEVERITY, message, actionText, actionFunction, autoHideDelayMillis);
    webpanelConfig.showingNewContentRefreshAlert = false;
}

function presentSuccess(message, actionText, actionFunction, autoHideDelayMillis) {
    presentMessage(SUCCESS_SEVERITY, message, actionText, actionFunction, autoHideDelayMillis);
    webpanelConfig.showingNewContentRefreshAlert = false;
}

function presentMessage(severity, message, actionText, actionFunction, autoHideDelayMillis) {
    var $messagePanel = $('#message-panel');
    $('#compact-message-container').removeClass('hidden');
    $messagePanel.attr('class', 'aui-message');
    $messageAction = $('#message-action');
    $messagePanel.addClass(severity);
    if (actionText && actionFunction) {
        currentMessageAction = actionFunction;
        $messageAction.text(actionText)
    } else {
        currentMessageAction = null;
        $messageAction.text('')
    }
    $('#message-details').text(message);
    var currentMessageId = createGuid();
    webpanelConfig.currentMessageId = currentMessageId;
    if (autoHideDelayMillis) {
        setTimeout(function() {
            if (webpanelConfig.currentMessageId === currentMessageId) {
                closeMessage();
            }
        }, autoHideDelayMillis);
    }
}

function handleMessageAction(event) {
    if (currentMessageAction) {
        currentMessageAction();
        closeMessage();
    }
    event.preventDefault();
}

function closeMessage() {
    $('#compact-message-container').addClass('hidden');
    webpanelConfig.currentMessageId  = null;
}

function pageClickHandler() {
    contentClickHandler('page');
}

function blogClickHandler() {
    contentClickHandler('blog');
}

function commentClickHandler() {
    contentClickHandler('comment');
}

function otherContentClickHandler() {
    contentClickHandler('other');
}

function contentClickHandler(contentType) {
    var groupConfig = getSelectedGroupConfig();
    sendAnalyticsEvent('confluence.hipchat.connect.sidebar.content.click', {
        dataGroupName: groupConfig['analytics-id'],
        contentType: contentType
    });
}

function sendAnalyticsEvent(eventName, data) {
    var allData = $.extend({
        sessionId: webpanelConfig.session.id,
        millisFromSessionStart: getMillisFromSessionStart()
    }, data);
    AJS.trigger('analyticsEvent', {
        name: eventName,
        data: allData
    });
}

function getMillisFromSessionStart() {
    return Date.now() - webpanelConfig.session.startTime;
}

function createGuid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
    }
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function periodicallySendSessionUpdates() {
    fireSessionAnalytics();
    setInterval(fireSessionAnalytics, SESSION_UPDATE_PERIOD_MILLISECONDS);
}

function fireSessionAnalytics() {
    var currentPanelId = getCurrentPanelId();
    var sessionDurationMillis = getMillisFromSessionStart();
    sendAnalyticsEvent('confluence.hipchat.connect.sidebar.session', {
        currentPanelId: currentPanelId,
        dataGroupChangeCount: webpanelConfig.session.dataGroupChangeCount,
        dataGroupSubselectChangeCount: webpanelConfig.session.dataGroupSubselectChangeCount,
        sessionDurationMillis: sessionDurationMillis
    });
}

$(window).on('hashchange', function () {
    updateTabSelection();
    webpanelConfig.session.dataGroupChangeCount++;
    getWebpanelData();
});