(function($) {
    "use strict";

    var chatBarEnabled = AJS.DarkFeatures.isEnabled('hipchat.chatbar');

    var Routes = {
        hipChatCall: function(userId, callType) {
            if(!userId) {
                return;
            }
            return "hipchat://hipchat.com/user/" +
                    encodeURI(userId) +
                    (callType ? "?call=" + encodeURI(callType) : "");
        }
    };

    var baseUrl = AJS.contextPath() + "/rest/hipchat/integration/1.0/users/";

    var hipChatClickHandler = function(online) {
        return function(e) {
            var button = $(this);

            var confluenceUserId = button.attr('data-user-id');

            var callerId = button.attr('data-caller-id');
            if (!callerId) {
                return;
            }

            var callType = button.attr('data-call-type');

            //If user is offline, then don't allow voice/video calls
            if (! online && callType) {
                return;
            }

            window.location.replace(Routes.hipChatCall(callerId, callType));

            AJS.trigger('analyticsEvent', {
                name: "hipchat.chatbar." + (callType || "chat"),
                data: {
                    userId: confluenceUserId
                }
            });

            e.preventDefault();
        }
    };

    var statusHandler = function (element) {
        return function (response) {
            if(!response || !response.presence) {
                return;
            }

            var confluenceUserId = response.userId;
            var hipChatUserId = response.hipChatUserId;
            var statusCode;
            var statusMessage;

            var buttons = $(element).find('.hipchat-chatbar .aui-button');
            buttons.attr('data-user-id', confluenceUserId);
            buttons.attr('data-caller-id', hipChatUserId);
            // Evil... userlink.js stops propagation of events, so we can't use delegate. :/
            buttons.click(hipChatClickHandler(response.presence.is_online));

            if(response.presence.is_online) {
                if(response.presence.show === "xa" || response.presence.show === "away") {
                    statusCode = "away";
                    statusMessage = AJS.I18n.getText("hipchat.presence.status.away");
                } else if (response.presence.show === "dnd") {
                    statusCode = "dnd";
                    statusMessage = AJS.I18n.getText("hipchat.presence.status.dnd");
                } else {
                    statusCode = "available";
                    statusMessage = AJS.I18n.getText("hipchat.presence.status.available");
                }
                buttons.filter('.hipchat-chat').attr('title', AJS.I18n.getText('hipchat.chat.available.chat')).removeAttr('aria-disabled');
                buttons.filter('.hipchat-voice').attr('title', AJS.I18n.getText('hipchat.chat.available.voice')).removeAttr('aria-disabled');
                buttons.filter('.hipchat-video').attr('title', AJS.I18n.getText('hipchat.chat.available.video')).removeAttr('aria-disabled');
            } else {
                statusCode = "offline";
                statusMessage = AJS.I18n.getText("hipchat.presence.status.offline");

                buttons.filter('.hipchat-chat').attr('title', AJS.I18n.getText('hipchat.chat.available.chat')).removeAttr('aria-disabled');
                buttons.filter('.hipchat-voice').attr('title', AJS.I18n.getText('hipchat.chat.unavailable.voice'));
                buttons.filter('.hipchat-video').attr('title', AJS.I18n.getText('hipchat.chat.unavailable.video'));
            }

            if(response.presence.status) {
                statusMessage += " (" + response.presence.status + ")";
            }

            $("div.values", element).append(Confluence.Templates.HipChat.Presence.badge({
                statusCode: statusCode,
                statusMessage: statusMessage
            }));

            AJS.trigger('analyticsEvent', {
                name: "hipchat.presence.user.found",
                data: {
                    userId: response.userId
                }
            });
        }
    };

    $(document).bind("ajaxComplete", function (e, res, req) {
        // There is no reliable event in the user popup we can use instead
        // this is an improvement over the v1 implementation (which regex'd then entire response text, not a url).
        if (/userinfopopup\.action/.test(req.url)) {
            $.each($(".vcard"), function (i, vcard) {
                var $vcard = $(vcard);

                var $content = $vcard.closest('.contents');
                var $profile = $content.find('.profile-macro').first();
                var $actions = $content.find('.actions').first();

                if ($profile.hasClass("hipchat-status-applied") || !$actions.length) {
                    // already done, or user popup not ready for hipchatification
                    return;
                }

                $profile.addClass("hipchat-status-applied");

                if(chatBarEnabled) {
                    $actions.addClass("hipchat-chatbar-support");

                    $actions.append(Confluence.Templates.HipChat.Presence.chatBar());

                    // restyle
                    $actions.find('.ajs-menu-bar').addClass('aui-buttons');
                    $actions.find('.ajs-button > a').addClass('aui-button');
                    $actions.find('.user-popup-more').addClass('aui-button');
                    $actions.find('.user-popup-more > span > span').addClass('aui-icon aui-icon-small aui-iconfont-more').text('');
                }

                var username = $(".userLogoLink", $vcard).attr('data-username');
                var url = baseUrl + encodeURIComponent(username);
                $.getJSON(url, statusHandler($content)).fail(function(jxr) {
                    if(jxr.status === 404) {
                        // Check is just missing from HipChat
                        try {
                            var result = JSON.parse(jxr.responseText);
                            if(result.userId) {
                                // Confluence user id, so known to Confluence, but unknown to HipChat, so we want to track this event.
                                AJS.trigger('analyticsEvent', {
                                    name: "hipchat.presence.user.unknown",
                                    data: {
                                        userId: result.userId
                                    }
                                });
                            }
                        } catch (e) {
                            // ignore
                        }
                    }
                });
            });
        }
    });
})(AJS.$);
