require([
            'jquery',
            'confluence/hipchat/integration/hipchat/discovery',
            'confluence/hipchat/spacetoroom/hipchat/discovery',
            'confluence/hipchat/integration/hipchat/discovery/popup'
        ],
        /**
         * HipChat space feature discovery
         * @exports confluence/hipchat/integration/discovery/space
         * @tainted Confluence.FeatureDiscovery
         * @tainted Confluence.Templates
         */
        function (
                $,
                integration,
                spacetoroom,
                discovery
        ) {
            "use strict";

            $(function () {
                var hipChatIntegrationUrl = AJS.contextPath() + "/spaces/hipchat2.action?key=" + encodeURIComponent(AJS.Meta.get("space-key"));
                var menuItem = $("#space-tools-menu-trigger");

                if(menuItem.length) {
                    discovery.show({
                        featureKey: "hipChatSpaceIntegration",
                        pluginKey: spacetoroom.pluginKey(),
                        analytics: "notifications.hipchat.space.discovery",
                        template: Confluence.Templates.Hipchat.Discovery.spaceIntegrationDialog,
                        name: "hipchat-space-integration-dialog",
                        target: menuItem,
                        shouldShow: function () {
                            return integration.isLinked()
                                && spacetoroom.isSpaceAdmin()
                                && !spacetoroom.hasSpaceConfiguration();
                        },
                        onAccept: function () {
                            window.location.assign(hipChatIntegrationUrl);
                        },
                        fixed: true
                    });

                    discovery.show({
                        featureKey: "hipChatServerIntegration",
                        pluginKey: spacetoroom.pluginKey(),
                        analytics: "notifications.hipchat.space.link",
                        template: Confluence.Templates.Hipchat.Discovery.spaceLinkDialog,
                        name: "hipchat-space-link-dialog",
                        target: menuItem,
                        /**
                         * Conditions for showing space level integration popup,
                         *      however the popup will only display if the user is not a site admin
                         *      but is a space admin.
                         *
                         * @returns {boolean}
                         */
                        shouldShow: function () {
                            return !integration.isLinked()
                                && integration.isConditionsMet()
                                && !integration.isAdmin()
                                && spacetoroom.isSpaceAdmin();
                        },
                        onAccept: function () {
                            window.location.assign(hipChatIntegrationUrl);
                        },
                        fixed: true
                    });
                }
            });


        });

