require([
            'jquery',
            'confluence/hipchat/integration/hipchat/discovery',
            'confluence/hipchat/integration/hipchat/discovery/popup'
        ],
        /**
         * HipChat integration feature discovery
         * @exports confluence/hipchat/integration/discovery/server
         * @tainted Confluence.FeatureDiscovery
         * @tainted Confluence.Templates
         */
        function (
                $,
                hipchat,
                discovery) {
            "use strict";

            $(function () {
                var hipChatIntegrationUrl = AJS.contextPath() + "/plugins/servlet/hipchat/configure";

                discovery.show({
                    featureKey: "hipChatServerIntegration",
                    pluginKey: hipchat.pluginKey(),
                    analytics: "notifications.hipchat.discovery",
                    template: Confluence.Templates.Hipchat.Discovery.integrationDialog,
                    name: "hipchat-integration-dialog",
                    target: $("#admin-menu-link"),
                    shouldShow: function () {
                        return ! hipchat.isLinked()
                                && hipchat.isConditionsMet()
                                && hipchat.isAdmin();
                    },
                    onAccept: function () {
                        window.location.assign(hipChatIntegrationUrl);
                    },
                    onDismiss: function() {},
                    fixed:false
                })
            });
        });
