define('confluence/hipchat/integration/hipchat/discovery',
        [
            'wrm/data'
        ],
        /**
         * HipChat integration feature discovery
         * @tainted WRM
         * @exports confluence/hipchat/integration/discovery/hipchat
         */
        function (wrmData) {
            "use strict";
            var pluginKey = "com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin";

            var dataKey = pluginKey + ":discovery-javascript-data.link-active";

            /**
             * @type {{linkActive:boolean, conditionsMet:boolean, admin: boolean}}
             */
            var discoveryData = wrmData.claim(dataKey);

            return {
                /**
                 * Is the instance linked to at least one HipChat instance
                 * @returns {boolean}
                 */
                isLinked: function () {
                    return discoveryData.linkActive === true;
                },
                /**
                 * Are the conditions met to show the discovery popups
                 *
                 * i.e. At least 5 users and at least 1 space
                 *
                 * @returns {boolean}
                 */
                isConditionsMet: function () {
                    return discoveryData.conditionsMet === true;
                },
                /**
                 * Is the user a site admin?
                 *
                 * @returns {boolean}
                 */
                isAdmin: function() {
                    return discoveryData.admin === true;
                },
                /**
                 * Get the plugin key of this module
                 *
                 * @returns {string}
                 */
                pluginKey: function () {
                    return pluginKey;
                }
            };
        });

