/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spi.impl;

import com.atlassian.plugins.hipchat.api.CallbackType;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class SpaceAwareHipChatRoutesProvider
implements HipChatRoutesProvider {
    private static final String HIPCHAT_SPACE_ADMIN = "{baseUrl}/spaces/hipchat2.action";
    private static final String HIPCHAT_SPACE_INVITE_ADMIN = "{baseUrl}/spaces/hipchat2-invite.action";
    private final String spaceKey;
    private final HipChatRoutesProvider defaultHipChatRoutesProvider;
    private final ApplicationProperties applicationProperties;

    public SpaceAwareHipChatRoutesProvider(String spaceKey, HipChatRoutesProvider defaultHipChatRoutesProvider, ApplicationProperties applicationProperties) {
        this.spaceKey = spaceKey;
        this.defaultHipChatRoutesProvider = defaultHipChatRoutesProvider;
        this.applicationProperties = applicationProperties;
    }

    protected String baseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public URI getUninstall() {
        return this.defaultHipChatRoutesProvider.getUninstall();
    }

    public URI installCallback() {
        return this.defaultHipChatRoutesProvider.installCallback();
    }

    public URI self() {
        return this.defaultHipChatRoutesProvider.self();
    }

    public URI homepage() {
        return this.defaultHipChatRoutesProvider.homepage();
    }

    public URI getPingHipChat() {
        return this.addSpaceKeyParam(this.defaultHipChatRoutesProvider.getPingHipChat());
    }

    public URI getBeginInstall() {
        return this.addSpaceKeyParam(this.defaultHipChatRoutesProvider.getBeginInstall());
    }

    public URI getCompleteInstall() {
        return this.addSpaceKeyParam(this.defaultHipChatRoutesProvider.getCompleteInstall());
    }

    public URI getBeginOauth2Uri() {
        return this.defaultHipChatRoutesProvider.getBeginOauth2Uri();
    }

    public URI getCompleteOauth2Uri() {
        return this.defaultHipChatRoutesProvider.getCompleteOauth2Uri();
    }

    public URI uninstallCallback() {
        return this.defaultHipChatRoutesProvider.uninstallCallback();
    }

    public URI webhookCallback(String resourcePath) {
        return this.defaultHipChatRoutesProvider.webhookCallback(resourcePath);
    }

    public URI getAdminConfigurationPage() {
        return UriBuilder.fromPath((String)HIPCHAT_SPACE_ADMIN).queryParam("key", new Object[]{this.spaceKey}).build(new Object[]{this.baseUrl()});
    }

    public URI getAdminInvitePage() {
        return UriBuilder.fromPath((String)HIPCHAT_SPACE_INVITE_ADMIN).queryParam("key", new Object[]{this.spaceKey}).build(new Object[]{this.baseUrl()});
    }

    public Map<CallbackType, URI> oauth2Callbacks() {
        return this.defaultHipChatRoutesProvider.oauth2Callbacks();
    }

    public URI getFindInviteUsersURI() {
        return this.defaultHipChatRoutesProvider.getFindInviteUsersURI();
    }

    public URI getIsInvitationsToGroupAllowedURI() {
        return this.defaultHipChatRoutesProvider.getIsInvitationsToGroupAllowedURI();
    }

    private URI addSpaceKeyParam(URI defaultUri) {
        UriBuilder b = this.getUriBuilder(defaultUri);
        b.queryParam("key", new Object[]{this.spaceKey});
        return b.build(new Object[0]);
    }

    private UriBuilder getUriBuilder(URI uri) {
        return UriBuilder.fromUri((URI)uri);
    }
}

