/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.webpanel;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.ConfluenceConnectUtil;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.webpanel.ConfluenceWebPanelCapabilityProvider;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.hipchat.api.HipChatDarkFeatureService;
import com.atlassian.plugins.hipchat.api.json.JsonableJacksonService;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ConfluenceWebPanelDataProvider
implements WebResourceDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceWebPanelDataProvider.class);
    private final HipChatRoutesProvider hipChatRoutesProvider;
    private final HipChatDarkFeatureService hipChatDarkFeatureService;
    private final JsonableJacksonService jacksonService;
    private final ApplicationProperties applicationProperties;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ConfluenceWebPanelCapabilityProvider confluenceWebPanelCapabilityProvider;
    private final SettingsManager settingsManager;

    public ConfluenceWebPanelDataProvider(HipChatRoutesProvider hipChatRoutesProvider, HipChatDarkFeatureService hipChatDarkFeatureService, JsonableJacksonService jacksonService, ApplicationProperties applicationProperties, WebResourceUrlProvider webResourceUrlProvider, ConfluenceWebPanelCapabilityProvider confluenceWebPanelCapabilityProvider, SettingsManager settingsManager) {
        this.hipChatRoutesProvider = hipChatRoutesProvider;
        this.hipChatDarkFeatureService = hipChatDarkFeatureService;
        this.jacksonService = jacksonService;
        this.applicationProperties = applicationProperties;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.confluenceWebPanelCapabilityProvider = confluenceWebPanelCapabilityProvider;
        this.settingsManager = settingsManager;
    }

    public Jsonable get() {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        Settings settings = this.settingsManager.getGlobalSettings();
        String baseUrl = settings.getBaseUrl();
        contextBuilder.put((Object)"allMappedSpacesFilter", (Object)"all-mapped-spaces");
        contextBuilder.put((Object)"spaceToRoomMappingUpdateEventTypeKey", (Object)"space-to-room-mapping-update");
        contextBuilder.put((Object)"sidebarDisabledEventTypeKey", (Object)"sidebar-disabled-event");
        contextBuilder.put((Object)"shareFailureEventTypeKey", (Object)"share-failure");
        contextBuilder.put((Object)"authenticationCompleteEventTypeKey", (Object)"authentication-complete");
        contextBuilder.put((Object)"userPermissionChangedEventTypeKey", (Object)"user-permission-changed");
        contextBuilder.put((Object)"contentChangedEventTypeKey", (Object)"content-changed");
        contextBuilder.put((Object)"contentViewedEventTypeKey", (Object)"content-viewed");
        String pluginKey = "com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin";
        String documentsImageUrl = baseUrl + "/download/resources/" + pluginKey + "/images/documents-98x93.png";
        contextBuilder.put((Object)"documentsImageUrl", (Object)documentsImageUrl);
        if (ConfluenceConnectUtil.isInGlanceBetaPeriod()) {
            String feedbackLinkUrl = "http://go.atlassian.com/confluence-sidebar-feedback";
            contextBuilder.put((Object)"feedbackLinkUrl", (Object)feedbackLinkUrl);
        } else {
            contextBuilder.put((Object)"feedbackLinkUrl", (Object)"");
        }
        ImmutableMap data = contextBuilder.build();
        return this.jacksonService.toJsonable((Object)data);
    }
}

