/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.HipChatRoomDefinition;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomLinkedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomUnlinkedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConnectSynchronisationTasks;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.GlanceFeatureEnablementTransitionEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.SynchronisationGoal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.ConnectEnablementManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatNotificationEnablementStateProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSidebarUpdater;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSynchronisationProcessor;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.ConfluenceConnectUtil;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.hipchat.api.events.HipChatServerRegisteredEvent;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.event.HipChatUnlinkedEvent;
import com.atlassian.plugins.hipchat.tasks.HipChatTasksExecutor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Internal
public class ConfluenceGlanceManager
implements InitializingBean,
DisposableBean,
LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceGlanceManager.class);
    private final ApplicationProperties applicationProperties;
    private final HipChatSidebarUpdater hipChatSidebarUpdater;
    private final EventPublisher eventPublisher;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final I18NBeanFactory i18NBeanFactory;
    private final EntityToRoomMappingManager entityToRoomMappingManager;
    private final SettingsManager settingsManager;
    private final HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider;
    private final ConnectEnablementManager connectEnablementManager;
    private final HipChatTasksExecutor hipChatTasksExecutor;
    private final HipChatSynchronisationProcessor hipChatSynchronisationProcessor;

    public ConfluenceGlanceManager(ApplicationProperties applicationProperties, HipChatSidebarUpdater hipChatSidebarUpdater, EventPublisher eventPublisher, HipChatLinkProvider hipChatLinkProvider, I18NBeanFactory i18NBeanFactory, EntityToRoomMappingManager entityToRoomMappingManager, SettingsManager settingsManager, HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider, ConnectEnablementManager connectEnablementManager, HipChatTasksExecutor hipChatTasksExecutor, HipChatSynchronisationProcessor hipChatSynchronisationProcessor) {
        this.applicationProperties = applicationProperties;
        this.hipChatSidebarUpdater = hipChatSidebarUpdater;
        this.eventPublisher = eventPublisher;
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.i18NBeanFactory = i18NBeanFactory;
        this.entityToRoomMappingManager = entityToRoomMappingManager;
        this.settingsManager = settingsManager;
        this.hipChatNotificationEnablementStateProvider = hipChatNotificationEnablementStateProvider;
        this.connectEnablementManager = connectEnablementManager;
        this.hipChatTasksExecutor = hipChatTasksExecutor;
        this.hipChatSynchronisationProcessor = hipChatSynchronisationProcessor;
    }

    @EventListener
    public void onLinkRegisteredEvent(HipChatServerRegisteredEvent hipChatServerRegisteredEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_OR_CREATE);
        }
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent spaceRemoveEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            this.handleSpaceGoneEvent((SpaceEvent)spaceRemoveEvent);
        }
    }

    @EventListener
    public void onSpaceArchivedEvent(SpaceArchivedEvent spaceArchivedEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            this.handleSpaceGoneEvent((SpaceEvent)spaceArchivedEvent);
        }
    }

    private void handleSpaceGoneEvent(SpaceEvent spaceEvent) {
        Space space = spaceEvent.getSpace();
        if (space != null) {
            String spaceKey = space.getKey();
            TreeSet<String> roomIds = new TreeSet<String>();
            Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForEntity(spaceKey);
            for (AOEntityToRoomMapping mapping : mappings) {
                String roomId = mapping.getRoomId();
                roomIds.add(roomId);
            }
            this.requestSynchroniseSidebars(roomIds, SynchronisationGoal.REMOVE_IF_LAST_MAPPING_DELETED);
        }
    }

    @EventListener
    public void handleGlobalSettingsChangedEvent(GlobalSettingsChangedEvent globalSettingsChangedEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            Settings oldSettings = globalSettingsChangedEvent.getOldSettings();
            Settings newSettings = globalSettingsChangedEvent.getNewSettings();
            String oldSiteTitle = ConfluenceConnectUtil.getSiteTitle(oldSettings);
            String newSiteTitle = ConfluenceConnectUtil.getSiteTitle(newSettings);
            if (!newSiteTitle.equals(oldSiteTitle)) {
                this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_GLANCE);
            } else {
                String oldBaseUrl = oldSettings.getBaseUrl();
                String newBaseUrl = newSettings.getBaseUrl();
                if (!newBaseUrl.equals(oldBaseUrl)) {
                    this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_GLANCE);
                }
                this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_GLANCE);
            }
        }
    }

    @EventListener
    public void onGlanceFeatureEnablementTransitionEvent(GlanceFeatureEnablementTransitionEvent glanceFeatureEnablementTransitionEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            if (glanceFeatureEnablementTransitionEvent.isEnabled()) {
                this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_OR_CREATE);
            } else {
                this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.REMOVE_UNCONDITIONALLY);
            }
        }
    }

    @EventListener
    public void handleHipChatUnlinkedEvent(HipChatUnlinkedEvent hipChatUnlinkedEvent) {
    }

    @EventListener
    public void handleSpaceToRoomLinked(SpaceToRoomLinkedEvent spaceToRoomLinkedEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            HipChatRoomDefinition roomDefinition = spaceToRoomLinkedEvent.getRoom();
            String roomId = roomDefinition.getRoomId();
            this.requestSynchroniseSidebarsForRoom(roomId, SynchronisationGoal.UPDATE_OR_CREATE);
        }
    }

    @EventListener
    public void handleSpaceToRoomUnlinked(SpaceToRoomUnlinkedEvent spaceToRoomUnlinkedEvent) {
        if (this.connectEnablementManager.isEnabled()) {
            HipChatRoomDefinition roomDefinition = spaceToRoomUnlinkedEvent.getRoom();
            String roomId = roomDefinition.getRoomId();
            this.requestSynchroniseSidebarsForRoom(roomId, SynchronisationGoal.REMOVE_IF_LAST_MAPPING_DELETED);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void onStart() {
        if (this.hipChatNotificationEnablementStateProvider.isNotificationsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Register HipChat glance manager event listener");
            }
            this.eventPublisher.register((Object)this);
            if (this.connectEnablementManager.isEnabled()) {
                this.requestSynchroniseSidebarsForAllRooms(SynchronisationGoal.UPDATE_OR_CREATE);
            }
        } else {
            logger.info("Detected notification processing is disabled.");
        }
    }

    public void destroy() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Un-register HipChat glance manager event listener");
        }
        this.eventPublisher.unregister((Object)this);
        ConnectSynchronisationTasks synchronisationTasks = ConnectSynchronisationTasks.getInstance();
        synchronisationTasks.clearTasks();
    }

    private void requestSynchroniseSidebarsForRoom(String roomId, SynchronisationGoal synchronisationGoal) {
        HashSet<String> roomIds = new HashSet<String>();
        roomIds.add(roomId);
        this.requestSynchroniseSidebars(roomIds, synchronisationGoal);
    }

    private void requestSynchroniseSidebarsForAllRooms(SynchronisationGoal synchronisationGoal) {
        HashSet<String> roomIds = new HashSet<String>();
        Iterable<AOEntityToRoomMapping> spaceToRoomMappings = this.entityToRoomMappingManager.getAll();
        for (AOEntityToRoomMapping spaceToRoomMapping : spaceToRoomMappings) {
            String roomId = spaceToRoomMapping.getRoomId();
            roomIds.add(roomId);
        }
        if (roomIds.size() > 0) {
            this.requestSynchroniseSidebars(roomIds, synchronisationGoal);
        }
    }

    private void requestSynchroniseSidebars(Set<String> roomIds, SynchronisationGoal synchronisationGoal) {
        ConnectSynchronisationTasks synchronisationTasks = ConnectSynchronisationTasks.getInstance();
        synchronisationTasks.addTasks(roomIds, synchronisationGoal);
        this.hipChatSynchronisationProcessor.initiateSynchronisation();
    }
}

