/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.rest;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.HipChatRoomDefinition;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomSettings;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomLinkedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomNotificationMappingCreatedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomNotificationMappingRemovedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomUnlinkedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config/{spaceKey}")
@Internal
public class SpaceToRoomConfigurationResource {
    private final Logger logger = LoggerFactory.getLogger(SpaceToRoomConfigurationResource.class);
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final HipChatSpaceToRoomService hipChatSpaceToRoomService;
    private final EventPublisher eventPublisher;
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;

    public SpaceToRoomConfigurationResource(SpaceManager spaceManager, PermissionManager permissionManager, HipChatSpaceToRoomService hipChatSpaceToRoomService, EventPublisher eventPublisher, SpaceToRoomNotificationProvider spaceToRoomNotificationProvider) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.hipChatSpaceToRoomService = hipChatSpaceToRoomService;
        this.eventPublisher = eventPublisher;
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
    }

    @PUT
    @Path(value="/{roomId}/{notificationName}")
    public Response enableNotification(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="roomId") String roomId, @PathParam(value="notificationName") String notificationName, @QueryParam(value="initialLink") @DefaultValue(value="false") boolean initialLink) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (!this.isSpaceAdmin(space)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Option<NotificationType> spaceToRoomNotificationOption = this.spaceToRoomNotificationProvider.getNotificationTypeForKey(notificationName);
        if (spaceToRoomNotificationOption.isDefined()) {
            NotificationType notificationType = (NotificationType)spaceToRoomNotificationOption.get();
            if (this.hipChatSpaceToRoomService.hasMappingForEntityRoomAndType(spaceKey, roomId, notificationType)) {
                return Response.ok().build();
            }
            HipChatRoomDefinition room = new HipChatRoomDefinition(roomId, roomId, true, HipChatRoomDefinition.RoomState.Visible);
            this.hipChatSpaceToRoomService.addNotificationForSpaceAndRoom(spaceKey, roomId, notificationType);
            if (initialLink) {
                this.eventPublisher.publish((Object)new SpaceToRoomLinkedEvent(space, room));
            }
            this.eventPublisher.publish((Object)new SpaceToRoomNotificationMappingCreatedEvent(space, room, notificationType));
            return Response.ok().build();
        }
        String message = "Unable to convert '" + notificationName + "' to an enum of type SpaceToRoomNotification";
        this.logger.debug(message);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    @DELETE
    @Path(value="/{roomId}/{notificationName}")
    public Response removeNotification(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="roomId") String roomId, @PathParam(value="notificationName") String notificationName) {
        if (!this.isSpaceAdmin(spaceKey)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Option<NotificationType> spaceToRoomNotificationOption = this.spaceToRoomNotificationProvider.getNotificationTypeForKey(notificationName);
        if (spaceToRoomNotificationOption.isDefined()) {
            NotificationType notificationType = (NotificationType)spaceToRoomNotificationOption.get();
            Option<SpaceToRoomSettings> settingsOption = this.hipChatSpaceToRoomService.getSpaceToRoomSettings(spaceKey, roomId);
            if (settingsOption.isEmpty()) {
                String message = "Unable to find settings for space/room '" + spaceKey + "/" + roomId;
                this.logger.debug(message);
                return Response.ok().build();
            }
            SpaceToRoomSettings settings = (SpaceToRoomSettings)settingsOption.get();
            HipChatRoomDefinition room = new HipChatRoomDefinition(roomId, roomId, true, HipChatRoomDefinition.RoomState.Visible);
            Space space = this.spaceManager.getSpace(spaceKey);
            if (!settings.getNotificationTypes().contains(notificationType)) {
                String message = "Notification type (" + notificationType.getKey() + ") is not set for space/room '" + spaceKey + "/" + roomId;
                this.logger.debug(message);
                return Response.ok().build();
            }
            this.eventPublisher.publish((Object)new SpaceToRoomUnlinkedEvent(space, room));
            this.hipChatSpaceToRoomService.removeNotificationForSpaceAndRoom(spaceKey, roomId, notificationType);
            this.eventPublisher.publish((Object)new SpaceToRoomNotificationMappingRemovedEvent(space, room, notificationType));
            return Response.ok().build();
        }
        String message = "Unable to convert '" + notificationName + "' to an enum of type SpaceToRoomNotification";
        this.logger.debug(message);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    @DELETE
    @Path(value="/{roomId}")
    public Response removeNotificationsForRoom(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="roomId") String roomId) {
        if (!this.isSpaceAdmin(spaceKey)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Option<SpaceToRoomSettings> settingsOption = this.hipChatSpaceToRoomService.getSpaceToRoomSettings(spaceKey, roomId);
        if (settingsOption.isEmpty()) {
            return Response.ok().build();
        }
        SpaceToRoomSettings settings = (SpaceToRoomSettings)settingsOption.get();
        Set<NotificationType> configuredNotificationTypes = settings.getNotificationTypes();
        HipChatRoomDefinition room = new HipChatRoomDefinition(roomId, roomId, true, HipChatRoomDefinition.RoomState.Visible);
        Space space = this.spaceManager.getSpace(spaceKey);
        for (NotificationType notificationType : this.spaceToRoomNotificationProvider.getNotificationTypes("space")) {
            if (!configuredNotificationTypes.contains(notificationType)) continue;
            this.eventPublisher.publish((Object)new SpaceToRoomNotificationMappingRemovedEvent(space, room, notificationType));
        }
        this.hipChatSpaceToRoomService.removeNotificationsForSpaceAndRoom(spaceKey, roomId);
        this.eventPublisher.publish((Object)new SpaceToRoomUnlinkedEvent(space, room));
        return Response.ok().build();
    }

    private boolean isSpaceAdmin(String spaceKey) {
        return this.isSpaceAdmin(this.spaceManager.getSpace(spaceKey));
    }

    @VisibleForTesting
    boolean isSpaceAdmin(Space space) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space) || this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

