/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.rest;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.BlogPostShareEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceContentItem;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceContentItemBuilder;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceContentItems;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceGlanceUpdateMetadata;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceWebPanelInitialContext;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceWebPanelUiContext;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.MappedSpace;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.MyWorkType;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.PageShareEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ShareContentToRoomRequest;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.ConfluenceConnectUtil;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.webpanel.ConfluenceWebPanelCapabilityProvider;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.glances.GlanceData;
import com.atlassian.hipchat.api.glances.GlanceUpdateData;
import com.atlassian.hipchat.api.glances.RoomAddonUiUpdateData;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.api.HipChatCallbackService;
import com.atlassian.plugins.hipchat.api.HipChatConfigurationContext;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/connect-api")
public class ConnectApiResource {
    private static final Logger logger = LoggerFactory.getLogger(ConnectApiResource.class);
    private static final String NO_EXCERPT = "";
    private static final Expansion spaceExpansion = new Expansion("space");
    private static final Expansion historyExpansion = new Expansion("history");
    private static final Expansion versionExpansion = new Expansion("version");
    private static final Expansion lastUpdatedExpansion = new Expansion("history", new Expansions(new Expansion[]{new Expansion("lastUpdated")}));
    private static final ContentType[] INTERESTED_CONTENT_TYPES = new ContentType[]{ContentType.PAGE, ContentType.BLOG_POST};
    private static final String INTERESTED_CONTENT_TYPES_CSV = ConnectApiResource.contentTypesToCsv(INTERESTED_CONTENT_TYPES);
    private final HipChatLinkProvider hipChatLinkProvider;
    private final HipChatAOUserManager hipChatAOUserManager;
    private final EntityToRoomMappingManager entityToRoomMappingManager;
    private final HipChatCallbackService hipChatCallbackService;
    private final SpaceManager spaceManager;
    private final CQLSearchService cqlSearchService;
    private final SettingsManager settingsManager;
    private final ContentEntityManager contentEntityManager;
    private final EventPublisher eventPublisher;
    final ConfluenceWebPanelCapabilityProvider confluenceWebPanelCapabilityProvider;
    private final I18nResolver i18nResolver;
    private final UserAccessor userAccessor;

    public ConnectApiResource(HipChatLinkProvider hipChatLinkProvider, HipChatAOUserManager hipChatAOUserManager, EntityToRoomMappingManager entityToRoomMappingManager, HipChatCallbackService hipChatCallbackService, SpaceManager spaceManager, CQLSearchService cqlSearchService, SettingsManager settingsManager, ContentEntityManager contentEntityManager, EventPublisher eventPublisher, ConfluenceWebPanelCapabilityProvider confluenceWebPanelCapabilityProvider, I18nResolver i18nResolver, UserAccessor userAccessor) {
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.hipChatAOUserManager = hipChatAOUserManager;
        this.entityToRoomMappingManager = entityToRoomMappingManager;
        this.hipChatCallbackService = hipChatCallbackService;
        this.spaceManager = spaceManager;
        this.cqlSearchService = cqlSearchService;
        this.settingsManager = settingsManager;
        this.contentEntityManager = contentEntityManager;
        this.eventPublisher = eventPublisher;
        this.confluenceWebPanelCapabilityProvider = confluenceWebPanelCapabilityProvider;
        this.i18nResolver = i18nResolver;
        this.userAccessor = userAccessor;
    }

    @POST
    @Path(value="/logoff")
    @Consumes(value={"application/json"})
    @AnonymousAllowed
    public Response logoff(@QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatLink hipChatLink;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, (hipChatLink = hipChatContext.getHipChatLink()).getId());
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    this.hipChatAOUserManager.delete(hipChatUser);
                    return Response.ok().build();
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    @POST
    @Path(value="/signal-user-oauth-complete")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response signalUserOauthComplete(@QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                Option roomIdOption = hipChatContext.getRoomId();
                if (roomIdOption.isDefined()) {
                    String hipChatRoomIdString = (String)roomIdOption.get();
                    Result<Void> pushResult = this.pushGlanceUpdate(hipChatUserIdString, hipChatRoomIdString);
                    if (pushResult.isSuccess()) {
                        return Response.ok((Object)"{}").build();
                    }
                    ResourceError resourceError = pushResult.error();
                    int statusCode = resourceError.getStatusCode();
                    return Response.status((int)statusCode).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    @POST
    @Path(value="/share-content-to-room")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response shareContentToRoom(ShareContentToRoomRequest shareContentToRoomRequest, @QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatLink hipChatLink;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, (hipChatLink = hipChatContext.getHipChatLink()).getId());
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    Option roomIdOption = hipChatContext.getRoomId();
                    if (roomIdOption.isDefined()) {
                        String roomId = (String)roomIdOption.get();
                        SortedSet<MappedSpace> mappedSpaces = this.getMappedSpacesForRoom(roomId);
                        if (mappedSpaces.size() > 0) {
                            String confluenceUserKey = hipChatUser.getUserKey();
                            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(confluenceUserKey));
                            long id = shareContentToRoomRequest.getContentId();
                            if (id > 0L) {
                                ContentEntityObject contentEntityObject = this.contentEntityManager.getById(id);
                                if (contentEntityObject == null || contentEntityObject.isDeleted()) {
                                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                                }
                                String hipChatRoomIdString = (String)roomIdOption.get();
                                HipChatAPI addonApi = hipChatLink.getAddonApi();
                                RoomService roomService = addonApi.rooms();
                                return this.shareToRoom(contentEntityObject, hipChatRoomIdString, confluenceUser, roomService);
                            }
                            logger.warn("Ignoring attempt to share content with an invalid ID (" + id + ").");
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                        }
                        ConfluenceContentItems items = this.buildNoMappedSpacesResponse(mappedSpaces);
                        return Response.ok((Object)items).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    private Response shareToRoom(ContentEntityObject contentEntityObject, String roomId, ConfluenceUser confluenceUser, RoomService roomService) {
        if (contentEntityObject instanceof Page) {
            PageShareEvent pageShareEvent = new PageShareEvent(this, confluenceUser, roomId, (Page)contentEntityObject);
            this.eventPublisher.publish((Object)pageShareEvent);
            return Response.ok((Object)"{}").build();
        }
        if (contentEntityObject instanceof BlogPost) {
            BlogPostShareEvent blogPostShareEvent = new BlogPostShareEvent(this, confluenceUser, roomId, (BlogPost)contentEntityObject);
            this.eventPublisher.publish((Object)blogPostShareEvent);
            return Response.ok((Object)"{}").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
    }

    private Result<Void> pushGlanceUpdate(final String hipchatUserId, final String hipchatRoomId) {
        Option hipChatLink = this.hipChatLinkProvider.getDefaultLink();
        return (Result)hipChatLink.flatMap((Function)new Function<HipChatLink, Option<Result<Void>>>(){

            public Option<Result<Void>> apply(HipChatLink link) {
                ConfluenceGlanceUpdateMetadata metadata = new ConfluenceGlanceUpdateMetadata("authentication-complete");
                GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(hipchatRoomId, ConnectApiResource.this.settingsManager, ConnectApiResource.this.entityToRoomMappingManager, ConnectApiResource.this.spaceManager, ConnectApiResource.this.i18nResolver, metadata);
                String glanceKey = ConfluenceConnectUtil.buildGlanceKey(hipchatRoomId);
                GlanceUpdateData glanceUpdateData = new GlanceUpdateData(glanceKey, glanceData);
                RoomAddonUiUpdateData roomAddonUiUpdateData = new RoomAddonUiUpdateData.Builder().addGlance(glanceUpdateData).build();
                HipChatAPI addonApi = link.getAddonApi();
                RoomService roomService = addonApi.rooms();
                Promise result = roomService.updateRoomAddonUiForUser(hipchatRoomId, hipchatUserId, roomAddonUiUpdateData);
                return Option.some((Object)result.claim());
            }
        }).getOrElse((Object)Result.error((String)"There is no link to HipChat, can't update glance content."));
    }

    @GET
    @Path(value="/glance-data")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getGlance(@QueryParam(value="signed_request") String jwtToken) {
        if (!this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
        Option roomIdOption = hipChatContext.getRoomId();
        if (roomIdOption.isDefined()) {
            String hipChatRoomId = (String)roomIdOption.get();
            GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(hipChatRoomId, this.settingsManager, this.entityToRoomMappingManager, this.spaceManager, this.i18nResolver, null);
            return Response.ok((Object)glanceData).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/get-initial-context/{maxItems}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getInitialContext(@PathParam(value="maxItems") int maxItems, @QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                ConfluenceContentItems contentResult;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatLink hipChatLink = hipChatContext.getHipChatLink();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, hipChatLink.getId());
                boolean confluenceHipChatUserMapped = false;
                ConfluenceWebPanelUiContext uiContext = this.getUiContext(hipChatUserId);
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    confluenceHipChatUserMapped = true;
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    Option roomIdOption = hipChatContext.getRoomId();
                    String roomId = (String)roomIdOption.get();
                    SortedSet<MappedSpace> mappedSpaces = this.getMappedSpacesForRoom(roomId);
                    contentResult = mappedSpaces.size() > 0 ? this.getInitialContent(maxItems, hipChatUser, uiContext, mappedSpaces) : this.buildNoMappedSpacesResponse(mappedSpaces);
                } else {
                    contentResult = this.buildEmptyItems();
                }
                ConfluenceWebPanelInitialContext initialContext = new ConfluenceWebPanelInitialContext(confluenceHipChatUserMapped, uiContext, contentResult);
                return Response.ok((Object)initialContext).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    @GET
    @Path(value="/latest-changes/{maxItems}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getLatestChanges(@PathParam(value="maxItems") int maxItems, @QueryParam(value="signed_request") String jwtToken) {
        return this.getUpdates("all-mapped-spaces", maxItems, jwtToken);
    }

    @GET
    @Path(value="/updates/{spaceFilter}/{maxItems}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getUpdates(@PathParam(value="spaceFilter") String spaceFilter, @PathParam(value="maxItems") int maxItems, @QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatLink hipChatLink;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, (hipChatLink = hipChatContext.getHipChatLink()).getId());
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    Option roomIdOption = hipChatContext.getRoomId();
                    if (roomIdOption.isDefined()) {
                        String roomId = (String)roomIdOption.get();
                        SortedSet<MappedSpace> mappedSpaces = this.getMappedSpacesForRoom(roomId);
                        if (mappedSpaces.size() > 0) {
                            String confluenceUserKey = hipChatUser.getUserKey();
                            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(confluenceUserKey));
                            ConfluenceContentItems items = this.getUpdatesImpl(spaceFilter, maxItems, confluenceUser, mappedSpaces);
                            return Response.ok((Object)items).build();
                        }
                        ConfluenceContentItems items = this.buildNoMappedSpacesResponse(mappedSpaces);
                        return Response.ok((Object)items).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    @GET
    @Path(value="/my-work/{myWorkType}/{maxItems}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getMyWork(@PathParam(value="myWorkType") String myWorkTypeString, @PathParam(value="maxItems") int maxItems, @QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatLink hipChatLink;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, (hipChatLink = hipChatContext.getHipChatLink()).getId());
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    Option roomIdOption = hipChatContext.getRoomId();
                    MyWorkType myWorkType = MyWorkType.parseMyWorkType(myWorkTypeString);
                    if (myWorkType == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    if (roomIdOption.isDefined()) {
                        String roomId = (String)roomIdOption.get();
                        SortedSet<MappedSpace> mappedSpaces = this.getMappedSpacesForRoom(roomId);
                        if (mappedSpaces.size() > 0) {
                            String confluenceUserKey = hipChatUser.getUserKey();
                            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(confluenceUserKey));
                            ConfluenceContentItems items = this.getMyWorkImpl(myWorkType, maxItems, confluenceUser, mappedSpaces);
                            return Response.ok((Object)items).build();
                        }
                        ConfluenceContentItems items = this.buildNoMappedSpacesResponse(mappedSpaces);
                        return Response.ok((Object)items).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    @GET
    @Path(value="/mentioned/{maxItems}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getMentionedContent(@PathParam(value="maxItems") int maxItems, @QueryParam(value="signed_request") String jwtToken) {
        try {
            if (this.hipChatCallbackService.isValidJwtToken(jwtToken)) {
                HipChatLink hipChatLink;
                HipChatConfigurationContext hipChatContext = this.hipChatCallbackService.extractConfigurationContext(jwtToken);
                String hipChatUserIdString = hipChatContext.getHipChatUserId();
                HipChatUserId hipChatUserId = new HipChatUserId(hipChatUserIdString, (hipChatLink = hipChatContext.getHipChatLink()).getId());
                Option hipChatUserOption = this.hipChatAOUserManager.findHipChatUserById(hipChatUserId);
                if (hipChatUserOption.isDefined()) {
                    AOHipChatUser hipChatUser = (AOHipChatUser)hipChatUserOption.get();
                    Option roomIdOption = hipChatContext.getRoomId();
                    if (roomIdOption.isDefined()) {
                        String roomId = (String)roomIdOption.get();
                        SortedSet<MappedSpace> mappedSpaces = this.getMappedSpacesForRoom(roomId);
                        if (mappedSpaces.size() > 0) {
                            String confluenceUserKey = hipChatUser.getUserKey();
                            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(confluenceUserKey));
                            ConfluenceContentItems items = this.getMentionedContentImpl(maxItems, confluenceUser, mappedSpaces);
                            return Response.ok((Object)items).build();
                        }
                        ConfluenceContentItems items = this.buildNoMappedSpacesResponse(mappedSpaces);
                        return Response.ok((Object)items).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return this.logAndReturnServerError(e);
        }
    }

    private Response logAndReturnServerError(Exception e) {
        logger.warn("An unexpected error occurred: ", (Throwable)e);
        return Response.serverError().build();
    }

    private ConfluenceWebPanelUiContext getUiContext(HipChatUserId hipChatUserId) {
        ConfluenceWebPanelUiContext.Builder uiContextBuilder = new ConfluenceWebPanelUiContext.Builder();
        if (hipChatUserId != null) {
            uiContextBuilder = this.confluenceWebPanelCapabilityProvider.isMyWorkTabEnabled() ? uiContextBuilder.setUpdatesTabEnabled(true).setMyWorkTabEnabled(true) : uiContextBuilder.setUpdatesTabEnabled(true).setMentionedTabEnabled(true);
        }
        return uiContextBuilder.build();
    }

    private ConfluenceContentItems getInitialContent(int maxItems, AOHipChatUser hipChatUser, ConfluenceWebPanelUiContext uiContext, SortedSet<MappedSpace> mappedSpaces) throws Exception {
        String confluenceUserKey = hipChatUser.getUserKey();
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(confluenceUserKey));
        if (uiContext.isUpdatesTabEnabled()) {
            return this.getUpdatesImpl("all-mapped-spaces", maxItems, confluenceUser, mappedSpaces);
        }
        if (uiContext.isMentionedTabEnabled()) {
            return this.getMentionedContentImpl(maxItems, confluenceUser, mappedSpaces);
        }
        if (uiContext.isMyWorkTabEnabled()) {
            return this.getMyWorkImpl(MyWorkType.ALL, maxItems, confluenceUser, mappedSpaces);
        }
        return this.buildEmptyItems();
    }

    private ConfluenceContentItems buildEmptyItems() {
        ConfluenceContentItem[] items = new ConfluenceContentItem[]{};
        MappedSpace[] mappedSpaces = new MappedSpace[]{};
        return new ConfluenceContentItems(NO_EXCERPT, items, mappedSpaces);
    }

    private ConfluenceContentItems buildNoMappedSpacesResponse(SortedSet<MappedSpace> mappedSpaces) {
        ArrayList<ConfluenceContentItem> items = new ArrayList<ConfluenceContentItem>();
        String message = this.i18nResolver.getText("confluence.plugins.hipchat.glance.no.spaces.mapped.error");
        items.add(ConfluenceContentItemBuilder.buildSubHeader(message));
        ConfluenceContentItems confluenceContentItems = new ConfluenceContentItems(NO_EXCERPT, items, mappedSpaces);
        return confluenceContentItems;
    }

    private ConfluenceContentItems getUpdatesImpl(String spaceFilter, int maxItems, ConfluenceUser confluenceUser, SortedSet<MappedSpace> mappedSpaces) throws Exception {
        String spacesCsv = "all-mapped-spaces".equals(spaceFilter) ? this.getMappedSpacesCsv(mappedSpaces) : "'" + spaceFilter + "'";
        String cql = String.format("type in (%s) and space in (%s) order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV, spacesCsv);
        List<ConfluenceContentItem> items = this.doSearch(cql, maxItems, confluenceUser);
        return this.buildResponseFromItems(items, mappedSpaces);
    }

    private ConfluenceContentItems getMyWorkImpl(MyWorkType myWorkType, int maxItems, ConfluenceUser confluenceUser, SortedSet<MappedSpace> mappedSpaces) throws Exception {
        String cql = this.getMyWorkTypeCql(myWorkType, maxItems);
        List<ConfluenceContentItem> items = this.doSearch(cql, maxItems, confluenceUser);
        return this.buildResponseFromItems(items, mappedSpaces);
    }

    private String getMyWorkTypeCql(MyWorkType myWorkType, final int maxItems) {
        return myWorkType.accept(new MyWorkType.Visitor<String>(){

            @Override
            public String visitAll() {
                return String.format("type in (%s) and (id in recentlyViewedContent(%d) or contributor = currentUser() or favourite = currentUser() or mention = currentUser()) order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV, maxItems);
            }

            @Override
            public String visitMentionedIn() {
                return String.format("type in (%s) and mention = currentUser() order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV);
            }

            @Override
            public String visitRecentlyWorkedOn() {
                return String.format("type in (%s) and contributor = currentUser() order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV);
            }

            @Override
            public String visitRecentlyVisited() {
                return String.format("type in (%s) and id in recentlyViewedContent(%d) order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV, maxItems);
            }

            @Override
            public String visitSavedForLater() {
                return String.format("type in (%s) and favourite = currentUser() order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV);
            }
        });
    }

    private boolean showContentType(ContentType contentType) {
        for (ContentType interestedContentType : INTERESTED_CONTENT_TYPES) {
            if (contentType != interestedContentType) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfluenceContentItems getMentionedContentImpl(int maxItems, ConfluenceUser confluenceUser, SortedSet<MappedSpace> mappedSpaces) throws Exception {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
        try {
            String cql = String.format("type in (%s) and mention = currentUser() order by lastmodified desc", INTERESTED_CONTENT_TYPES_CSV);
            List<ConfluenceContentItem> items = this.doSearch(cql, maxItems, confluenceUser);
            ConfluenceContentItems confluenceContentItems = this.buildResponseFromItems(items, mappedSpaces);
            return confluenceContentItems;
        }
        finally {
            AuthenticatedUserThreadLocal.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfluenceContentItem> doSearch(String cql, int maxItems, ConfluenceUser confluenceUser) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
        try {
            PageResponse searchResults = this.cqlSearchService.searchContent(cql, new Expansion[]{spaceExpansion, historyExpansion, versionExpansion, lastUpdatedExpansion});
            List contentItems = searchResults.getResults();
            int resultCount = contentItems.size();
            ArrayList<ConfluenceContentItem> items = new ArrayList<ConfluenceContentItem>(resultCount);
            for (Content contentItem : contentItems) {
                ContentId contentId;
                ContentType contentType = contentItem.getType();
                if (!this.showContentType(contentType) || !(contentId = contentItem.getId()).isSet()) continue;
                long id = contentId.asLong();
                Map links = contentItem.getLinks();
                Link webLink = (Link)links.get(LinkType.WEB_UI);
                String url = webLink.getPath();
                String absoluteUrl = baseUrl + url;
                String title = contentItem.getTitle();
                String spaceName = contentItem.getSpace().getName();
                History history = contentItem.getHistory();
                Version version = contentItem.getVersion();
                String changeType = this.getChangeType(contentType, version);
                Reference lastUpdated = history.getLastUpdatedRef();
                Version lastUpdatedVersion = (Version)lastUpdated.get();
                DateTime modifiedDateTime = lastUpdatedVersion.getWhen();
                long updatedTimestamp = modifiedDateTime.getMillis();
                ConfluenceContentItem item = ConfluenceContentItemBuilder.buildLink(id, title, absoluteUrl, spaceName, contentType, changeType, NO_EXCERPT, updatedTimestamp);
                items.add(item);
                if (items.size() < maxItems) continue;
                break;
            }
            ArrayList<ConfluenceContentItem> arrayList = items;
            return arrayList;
        }
        finally {
            AuthenticatedUserThreadLocal.set(null);
        }
    }

    private String getChangeType(ContentType contentType, Version version) {
        Person by = version.getBy();
        String userDisplayName = by == null ? this.i18nResolver.getText("confluence.plugins.hipchat.glance.unknown.updater.display.name") : by.getDisplayName();
        if (contentType == ContentType.COMMENT) {
            return this.i18nResolver.getText("confluence.plugins.hipchat.glance.change.type.commented.by", new Serializable[]{userDisplayName});
        }
        if (version.getNumber() > 1) {
            return this.i18nResolver.getText("confluence.plugins.hipchat.glance.change.type.updated.by", new Serializable[]{userDisplayName});
        }
        return this.i18nResolver.getText("confluence.plugins.hipchat.glance.change.type.created.by", new Serializable[]{userDisplayName});
    }

    private ConfluenceContentItems buildResponseFromItems(List<ConfluenceContentItem> items, SortedSet<MappedSpace> mappedSpaces) {
        ConfluenceContentItems confluenceContentItems = new ConfluenceContentItems(NO_EXCERPT, items, mappedSpaces);
        return confluenceContentItems;
    }

    private SortedSet<MappedSpace> getMappedSpacesForRoom(String roomId) {
        TreeSet<MappedSpace> mappedSpaces = new TreeSet<MappedSpace>();
        Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForRoom(roomId);
        for (AOEntityToRoomMapping mapping : mappings) {
            String spaceKey = mapping.getEntityKey();
            Space space = this.spaceManager.getSpace(spaceKey);
            String spaceName = space.getName();
            MappedSpace mappedSpace = new MappedSpace(spaceKey, spaceName);
            mappedSpaces.add(mappedSpace);
        }
        return mappedSpaces;
    }

    private String getMappedSpacesCsv(SortedSet<MappedSpace> mappedSpaces) {
        StringBuilder spaceKeysCsv = new StringBuilder();
        String nextSeparator = NO_EXCERPT;
        for (MappedSpace mappedSpace : mappedSpaces) {
            String spaceKey = mappedSpace.getSpaceKey();
            spaceKeysCsv.append(nextSeparator);
            spaceKeysCsv.append('\'');
            spaceKeysCsv.append(spaceKey);
            spaceKeysCsv.append('\'');
            nextSeparator = ",";
        }
        return spaceKeysCsv.toString();
    }

    private static String contentTypesToCsv(ContentType[] contentTypes) {
        StringBuilder csv = new StringBuilder();
        String nextSeparator = NO_EXCERPT;
        for (ContentType contentType : contentTypes) {
            csv.append(nextSeparator);
            csv.append(contentType.getValue());
            nextSeparator = ",";
        }
        return csv.toString();
    }
}

