/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.model;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.RoomContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PageShareEvent
extends PageEvent
implements RoomContext,
Created {
    private final ConfluenceUser notifyingUser;
    private final String roomId;
    private final ImmutableMap<String, Serializable> context;

    public PageShareEvent(Object src, ConfluenceUser notifyingUser, String roomId, Page page) {
        this(src, notifyingUser, roomId, page, (Map<String, Serializable>)ImmutableMap.of());
    }

    public PageShareEvent(Object src, ConfluenceUser notifyingUser, String roomId, Page page, Map<String, Serializable> context) {
        super(src, page);
        this.notifyingUser = (ConfluenceUser)Preconditions.checkNotNull((Object)notifyingUser);
        this.roomId = (String)Preconditions.checkNotNull((Object)roomId);
        this.context = ImmutableMap.copyOf(context);
    }

    public Option<UserKey> getNotifyingUser() {
        return Option.some((Object)this.notifyingUser.getKey());
    }

    @Override
    @Nonnull
    public String getRoomId() {
        return this.roomId;
    }

    @Nonnull
    public ImmutableMap<String, Serializable> getContext() {
        return this.context;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PageShareEvent)) {
            return false;
        }
        PageShareEvent that = (PageShareEvent)o;
        return this.context.equals(that.context);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.context});
    }
}

