/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.discovery;

import com.atlassian.cache.compat.Supplier;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.ResultFilter;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.searchfilter.DeactivatedUserSearchFilter;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HipChatDiscoveryConditionSupplier
implements Supplier<Boolean> {
    private final Logger LOGGER = LoggerFactory.getLogger(HipChatDiscoveryConditionSupplier.class);
    public static final int REQUIRED_USER_COUNT = 5;
    public static final int REQUIRED_SPACE_COUNT = 1;
    private final SpaceManager spaceManager;
    private final SearchManager searchManager;

    public HipChatDiscoveryConditionSupplier(SpaceManager spaceManager, SearchManager searchManager) {
        this.spaceManager = spaceManager;
        this.searchManager = searchManager;
    }

    @Override
    public Boolean get() {
        try {
            ContentTypeQuery typeQuery = new ContentTypeQuery(ContentTypeEnum.PERSONAL_INFORMATION);
            DeactivatedUserSearchFilter searchFilter = DeactivatedUserSearchFilter.getInstance();
            SubsetResultFilter resultFilter = new SubsetResultFilter(5);
            ContentSearch contentSearch = new ContentSearch((SearchQuery)typeQuery, (SearchSort)CreatedSort.DEFAULT, (SearchFilter)searchFilter, (ResultFilter)resultFilter);
            SearchResults results = this.searchManager.search((ISearch)contentSearch);
            boolean hasSufficientUsers = results.getUnfilteredResultsCount() >= 5;
            int numberOfSpaces = this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT).size();
            boolean hasSufficientSpaces = numberOfSpaces >= 1;
            return hasSufficientSpaces && hasSufficientUsers;
        }
        catch (InvalidSearchException e) {
            this.LOGGER.warn("Error encountered attempting to query lucene index for personal information objects. Discovery condition will resolve to false as a result.", (Throwable)e);
            return false;
        }
    }
}

