define("confluence-hipchat-emoticons",
    [
        "jquery",
        "confluence-hipchat-emoticons/completion/CompletionManager",
        "confluence-hipchat-emoticons/data/DataManager",
        "confluence-hipchat-emoticons/menu/MenuItemOverrider"
    ],
    function (
        $,
        CompletionManager,
        DataManager,
        MenuItemOverrider) {

        $(document).on("postPaste", function(ev, pl, o) {
            var $el = $("img", o.node);
            if ($el.data("hipchatEmoticon")) {
                $el.removeClass("confluence-embedded-image confluence-external-resource");
            }
        });

        return {
            start: function () {
                DataManager.initializeData();
                CompletionManager.start();
                MenuItemOverrider.start();
            }
        };
    });

AJS.bind("init.rte", function () {
    "use strict";
    require("confluence-hipchat-emoticons").start();
});
