/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.service;

import com.atlassian.confluence.plugins.hipchat.emoticons.HipChatEmoticon;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.HipChatEmoticonService;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.emoticons.EmoticonService;
import com.atlassian.hipchat.api.emoticons.EmoticonType;
import com.atlassian.hipchat.api.emoticons.GetAllEmoticonsResult;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatEmoticonServiceImpl
implements HipChatEmoticonService {
    private static final Logger LOG = LoggerFactory.getLogger(HipChatEmoticonServiceImpl.class);
    private final BundleContext bundleContext;
    private final LoadingCache<HipChatLinkId, Pair<Option<String>, Map<String, HipChatEmoticon>>> emoticonCache;

    public HipChatEmoticonServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.emoticonCache = CacheBuilder.newBuilder().initialCapacity(1).refreshAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new EmoticonCacheLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<HipChatEmoticon> list() {
        HipChatLinkProviderWrapper linkProviderWrapper = new HipChatLinkProviderWrapper();
        try {
            HipChatLinkId id = linkProviderWrapper.getDefaultId();
            if (id == null) {
                List<HipChatEmoticon> list = Collections.emptyList();
                return list;
            }
            Collection<HipChatEmoticon> collection = ((Map)((Pair)this.emoticonCache.getUnchecked((Object)id)).right()).values();
            return collection;
        }
        finally {
            try {
                linkProviderWrapper.close();
            }
            catch (Exception e) {
                LOG.debug("Could not close HipChatLinkProviderWrapper", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HipChatEmoticon findByShortcut(String shortcut) {
        HipChatLinkProviderWrapper linkProviderWrapper = new HipChatLinkProviderWrapper();
        try {
            HipChatLinkId id = linkProviderWrapper.getDefaultId();
            if (id == null) {
                HipChatEmoticon hipChatEmoticon = null;
                return hipChatEmoticon;
            }
            HipChatEmoticon hipChatEmoticon = (HipChatEmoticon)((Map)((Pair)this.emoticonCache.getUnchecked((Object)id)).right()).get(shortcut);
            return hipChatEmoticon;
        }
        finally {
            try {
                linkProviderWrapper.close();
            }
            catch (Exception e) {
                LOG.debug("Could not close HipChatLinkProviderWrapper", (Throwable)e);
            }
        }
    }

    private final class HipChatLinkProviderWrapper
    implements AutoCloseable {
        private final ServiceReference linkProviderReference;

        private HipChatLinkProviderWrapper() {
            this.linkProviderReference = HipChatEmoticonServiceImpl.this.bundleContext.getServiceReference("com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider");
        }

        private HipChatLinkProvider getHipChatLinkProvider() {
            return this.linkProviderReference != null ? (HipChatLinkProvider)HipChatEmoticonServiceImpl.this.bundleContext.getService(this.linkProviderReference) : null;
        }

        private HipChatLinkId getDefaultId() {
            HipChatLinkProvider linkProvider = this.getHipChatLinkProvider();
            if (linkProvider == null) {
                return null;
            }
            Option link = linkProvider.getDefaultLink();
            return link.isDefined() ? ((HipChatLink)link.get()).getId() : null;
        }

        @Override
        public void close() throws Exception {
            if (this.linkProviderReference != null) {
                HipChatEmoticonServiceImpl.this.bundleContext.ungetService(this.linkProviderReference);
            }
        }
    }

    private class EmoticonCacheLoader
    extends CacheLoader<HipChatLinkId, Pair<Option<String>, Map<String, HipChatEmoticon>>> {
        private static final int PAGE_SIZE = 100;
        private Pair<Option<String>, Map<String, HipChatEmoticon>> EMPTY = Pair.pair((Object)Option.none(String.class), Collections.emptyMap());
        private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

        private EmoticonCacheLoader() {
        }

        private ListenableFuture<Pair<Option<String>, Map<String, HipChatEmoticon>>> retrieve(final HipChatLinkId linkId, final Option<String> existingETag, final Map<String, HipChatEmoticon> existingEmoticons) {
            return this.executor.submit((Callable)new Callable<Pair<Option<String>, Map<String, HipChatEmoticon>>>(){

                @Override
                public Pair<Option<String>, Map<String, HipChatEmoticon>> call() throws Exception {
                    HipChatLinkProviderWrapper hipChatLinkProviderWrapper = new HipChatLinkProviderWrapper();
                    if (hipChatLinkProviderWrapper.getHipChatLinkProvider() == null) {
                        return EmoticonCacheLoader.this.EMPTY;
                    }
                    Option hipchatLink = hipChatLinkProviderWrapper.getHipChatLinkProvider().getLinkById(linkId);
                    if (hipchatLink.isEmpty()) {
                        return EmoticonCacheLoader.this.EMPTY;
                    }
                    EmoticonService emoticonService = ((HipChatLink)hipchatLink.get()).getAddonApi().emoticons();
                    Option etag = null;
                    HashMap emoticonModelList = Maps.newHashMap();
                    LOG.info("Fetching whole list of emoticons from HipChat link {}", (Object)((HipChatLink)hipchatLink.get()).getId());
                    boolean moreAvailable = true;
                    int startIndex = 0;
                    while (moreAvailable) {
                        LOG.debug("Fetching page {} of HipChat emoticons", (Object)(startIndex / 100));
                        Result.CacheableResult result = (Result.CacheableResult)emoticonService.getAllEmoticons(Option.option((Object)startIndex), Option.option((Object)100), Option.option((Object)EmoticonType.ALL), startIndex == 0 ? existingETag : Option.none(String.class)).claim();
                        if (result.isError()) {
                            LOG.warn("Was unable to fetch HipChat emoticon list.", result.error().toThrowable());
                            return EmoticonCacheLoader.this.EMPTY;
                        }
                        if (startIndex == 0) {
                            if (result.isNotModified()) {
                                LOG.info("List of emoticons we currently have is still current.");
                                return Pair.pair((Object)existingETag, (Object)existingEmoticons);
                            }
                            etag = result.getEtag();
                        }
                        moreAvailable = false;
                        for (GetAllEmoticonsResult.EmoticonItem emoticonItem : ((GetAllEmoticonsResult)result.success()).getItems()) {
                            emoticonModelList.put(emoticonItem.getShortcut(), new HipChatEmoticon(emoticonItem.getShortcut(), emoticonItem.getUrl()));
                            moreAvailable = true;
                        }
                        startIndex += 100;
                    }
                    LOG.info("Fetched {} emoticons from HipChat server", (Object)emoticonModelList.size());
                    LOG.debug("Emoticon list ETag is {}", etag.getOrElse((Object)"<NO ETAG>"));
                    return Pair.pair(etag, (Object)emoticonModelList);
                }
            });
        }

        public ListenableFuture<Pair<Option<String>, Map<String, HipChatEmoticon>>> reload(@Nonnull HipChatLinkId linkId, Pair<Option<String>, Map<String, HipChatEmoticon>> oldValue) throws Exception {
            return this.retrieve(linkId, (Option<String>)((Option)oldValue.left()), (Map)oldValue.right());
        }

        public Pair<Option<String>, Map<String, HipChatEmoticon>> load(@Nonnull HipChatLinkId linkId) throws Exception {
            return (Pair)this.retrieve(linkId, (Option<String>)Option.none(String.class), null).get();
        }
    }
}

