/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.util;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportEolCheckUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportEolCheckUtil.class);
    private static final int DEFAULT_LATEST_MAJOR = 5;
    private static final int DEFAULT_LATEST_MINOR = 10;
    private static final int MAINTENANCE_THRESHOLD = 3;
    private static final int STATUS_NOT_FOUND = 404;
    private static final String CONFLUENCE_VERSION_BY_NAME_URL = "https://marketplace.atlassian.com/rest/2.0-beta/products/key/confluence/versions/name/";
    private static final String CONFLUENCE_VERSION_LATEST = "https://marketplace.atlassian.com/rest/2.0-beta/products/key/confluence/versions/latest";
    private static final String CONTENT_TYPE = "application/json";
    private static final String EOL_FILE_NAME = "confluence-healthcheck-eol.json";

    public static JSONObject getVersionFromMarketplace(File eolFile) throws IOException {
        int latestMinor;
        int latestMajor;
        int supportedMajor = 5;
        int supportedMinor = 8;
        String[] latestVersionString = SupportEolCheckUtil.getLatestConfluenceVersionName();
        if (latestVersionString.length >= 2) {
            latestMajor = Integer.parseInt(latestVersionString[0]);
            latestMinor = Integer.parseInt(latestVersionString[1]);
        } else {
            latestMajor = 5;
            latestMinor = 10;
        }
        HashMap<Object, String> versionInfo = new HashMap<Object, String>();
        block0: while (supportedMajor <= latestMajor) {
            for (int maintenance = 0; maintenance <= 3; ++maintenance) {
                String version = String.format("%d.%d", supportedMajor, supportedMinor);
                HttpResponse response = SupportEolCheckUtil.makeRequestToMarketplace(CONFLUENCE_VERSION_BY_NAME_URL + (String)version + "." + String.valueOf(maintenance));
                String mimeType = ContentType.get((HttpEntity)response.getEntity()).getMimeType();
                if (response.getStatusLine().getStatusCode() != 404 && mimeType.equals(CONTENT_TYPE)) {
                    String contentString = EntityUtils.toString((HttpEntity)response.getEntity());
                    versionInfo.put(version, SupportEolCheckUtil.getReleaseDateFromVersion(new JSONObject(contentString)));
                    ++supportedMinor;
                    continue block0;
                }
                if (maintenance != 3) continue;
                ++supportedMajor;
                supportedMinor = 0;
            }
        }
        if (!versionInfo.isEmpty()) {
            JSONArray versionArray = new JSONArray();
            for (Map.Entry entry : versionInfo.entrySet()) {
                versionArray.put((Object)SupportEolCheckUtil.makeVersionObject((String)entry.getKey(), (String)entry.getValue()));
            }
            JSONObject filteredVersions = new JSONObject();
            filteredVersions.put("versions", (Object)versionArray);
            if (eolFile != null) {
                SupportEolCheckUtil.writeToFile(eolFile, filteredVersions);
            }
            return filteredVersions;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File eolFile, JSONObject versionInfoJson) {
        block13: {
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(eolFile), "UTF-8");
                if (versionInfoJson == null) break block13;
                try {
                    writer.write(versionInfoJson.toString());
                }
                catch (IOException ex) {
                    LOGGER.error("An error occurred when writing the version information into confluence-healthcheck-eol.json file", (Throwable)ex);
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Not able to close the output stream writer", (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Not able to open file writer to write new version information content into confluence-healthcheck-eol.jsonfile", (Throwable)ex);
            }
        }
    }

    private static String[] getLatestConfluenceVersionName() throws IOException {
        HttpResponse response = SupportEolCheckUtil.makeRequestToMarketplace(CONFLUENCE_VERSION_LATEST);
        String mimeType = ContentType.get((HttpEntity)response.getEntity()).getMimeType();
        if (response.getStatusLine().getStatusCode() != 404 && mimeType.equals(CONTENT_TYPE)) {
            String contentString = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject json = new JSONObject(contentString);
            String releaseDate = json.getString("name");
            return releaseDate.split("\\.");
        }
        return new String[0];
    }

    private static String getReleaseDateFromVersion(JSONObject versionJson) {
        return versionJson.getString("releaseDate");
    }

    private static HttpResponse makeRequestToMarketplace(String url) throws IOException {
        HttpGet request = new HttpGet(url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        return httpClient.execute((HttpUriRequest)request);
    }

    private static JSONObject makeVersionObject(String name, String releaseDate) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("name", (Object)name);
        object.put("releaseDate", (Object)releaseDate);
        return object;
    }
}

