/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.upgrade;

import com.atlassian.confluence.plugins.healthcheck.util.SupportEolCheckUtil;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceHealthCopyEolFileTask
implements PluginUpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceHealthCopyEolFileTask.class);
    private static final int BUILD_NUMBER = 1;
    private static final String DESCRIPTION = "Copy the default confluence-healthcheck-eol.json file in Confluence shared home directory";
    private static final String CIH_PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-healthcheck-plugin";
    private static final String EOL_FILE_NAME = "confluence-healthcheck-eol.json";
    private final BootstrapManager bootstrapManager;

    public InstanceHealthCopyEolFileTask(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return DESCRIPTION;
    }

    public String getPluginKey() {
        return CIH_PLUGIN_KEY;
    }

    public Collection<Message> doUpgrade() {
        LOGGER.info("Running Confluence Instance Health upgrade task {}. Copying the default end of life JSON file into shared home directory.", (Object)1);
        File file = new File(this.bootstrapManager.getSharedHome(), EOL_FILE_NAME);
        JSONObject versionInfoJson = null;
        try {
            versionInfoJson = SupportEolCheckUtil.getVersionFromMarketplace(file);
        }
        catch (IOException ex) {
            LOGGER.info("Not able to retrieve or parse version information from Marketplace, trying the fallback method to create the default eol.json file");
            try {
                versionInfoJson = this.constructDefaultJsonContent();
            }
            catch (JSONException e) {
                LOGGER.error("An error occurred when constructing the default JSON content for the confluence-healthcheck-eol.json file");
            }
        }
        if (versionInfoJson != null) {
            SupportEolCheckUtil.writeToFile(file, versionInfoJson);
        }
        return Collections.emptyList();
    }

    private JSONObject constructDefaultJsonContent() throws JSONException {
        JSONObject conf510 = new JSONObject();
        conf510.put("name", (Object)"5.10");
        conf510.put("releaseDate", (Object)"2016-06-09");
        JSONObject conf509 = new JSONObject();
        conf509.put("name", (Object)"5.9");
        conf509.put("releaseDate", (Object)"2015-11-24");
        JSONObject conf508 = new JSONObject();
        conf508.put("name", (Object)"5.8");
        conf508.put("releaseDate", (Object)"2015-06-02");
        JSONArray array = new JSONArray();
        array.put((Object)conf510);
        array.put((Object)conf509);
        array.put((Object)conf508);
        JSONObject versionInfoJson = new JSONObject();
        versionInfoJson.put("versions", (Object)array);
        return versionInfoJson;
    }
}

