/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.tomcat;

import com.atlassian.confluence.plugins.healthcheck.common.Version;
import com.atlassian.confluence.plugins.healthcheck.tomcat.TomcatHelper;
import com.atlassian.confluence.status.service.SystemCompatibilityService;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.DefaultSupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class TomcatHealthCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "help.supported.platforms";
    private static final String HELP_TOMCAT_BUG_PATH = "confluence.healthcheck.tomcat.version.bug.url";
    private static final List<String> knownBadVersions = Arrays.asList("6.0.24", "6.0.25", "6.0.26", "6.0.27", "6.0.28", "6.0.29", "6.0.30", "6.0.31", "6.0.32");
    private final I18nResolver i18nResolver;
    private final SystemCompatibilityService systemCompatibilityService;
    private final TomcatHelper tomcatHelper;
    private final SupportHealthStatusFactory healthStatusFactory;
    private final String helpTomcatBugUrl;

    public TomcatHealthCheck(I18nResolver i18nResolver, SystemCompatibilityService systemCompatibilityService, TomcatHelper tomcatHelper, HelpPathResolver helpPathResolver) {
        this.i18nResolver = i18nResolver;
        this.systemCompatibilityService = systemCompatibilityService;
        this.tomcatHelper = tomcatHelper;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
        this.helpTomcatBugUrl = helpPathResolver.getHelpPath(HELP_TOMCAT_BUG_PATH).getUrl();
    }

    public SupportHealthStatus check() {
        String serverInfo = this.tomcatHelper.getAppServerNameAndVersion();
        if (serverInfo == null) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.app.server.unknown"), SupportHealthStatus.Severity.CRITICAL);
        }
        if (!serverInfo.toLowerCase().contains("tomcat")) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.app.server.noTomcat"), SupportHealthStatus.Severity.MAJOR);
        }
        Version tomcatVersion = new Version(serverInfo.substring(serverInfo.indexOf(47) + 1));
        if (!this.systemCompatibilityService.getSupportedTomcatVersions().contains(tomcatVersion.getMajorAndMinor())) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.app.server.badTomcatVersion", new Serializable[]{tomcatVersion.getFullVersion()}), SupportHealthStatus.Severity.MAJOR);
        }
        if (knownBadVersions.contains(tomcatVersion.getFullVersion())) {
            return new DefaultSupportHealthStatus(false, this.i18nResolver.getText("confluence.healthcheck.app.server.tomcatWithBugs", new Serializable[]{serverInfo}), System.currentTimeMillis(), Application.Confluence, SupportHealthStatus.Severity.WARNING, this.helpTomcatBugUrl);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.app.server.valid", new Serializable[]{serverInfo}));
    }

    public static List<String> getKnownBadVersions() {
        return knownBadVersions;
    }
}

