/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.support;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;

public final class HsqlHealthCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "confluence.healthcheck.hsql.url";
    private static final String H2DIALECT = "h2dialect";
    private final I18nResolver i18nResolver;
    private final LicenseService licenseService;
    private final SupportHealthStatusFactory healthStatusFactory;
    private final SystemInformationService systemInformationService;

    public HsqlHealthCheck(I18nResolver i18nResolver, SystemInformationService service, LicenseService licenseService, HelpPathResolver helpPathResolver) {
        this.i18nResolver = i18nResolver;
        this.systemInformationService = service;
        this.licenseService = licenseService;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    public SupportHealthStatus check() {
        boolean evaluationOrDevLicense;
        String databaseDialect = this.systemInformationService.getDatabaseInfo().getDialect();
        ConfluenceLicense license = this.licenseService.retrieve();
        boolean bl = evaluationOrDevLicense = license.isEvaluation() || license.getLicenseType().equals((Object)LicenseType.DEVELOPER);
        if (HibernateConfig.isHsqlDialect((String)databaseDialect)) {
            if (!evaluationOrDevLicense) {
                return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.hsql.database.on.production"), SupportHealthStatus.Severity.MAJOR);
            }
            return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.hsql.database.on.eval"));
        }
        if (databaseDialect.toLowerCase().contains(H2DIALECT)) {
            if (!evaluationOrDevLicense) {
                return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.h2.database.on.production"), SupportHealthStatus.Severity.MAJOR);
            }
            return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.h2.database.on.eval"));
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.hsql.valid"));
    }
}

