/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.support;

import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import javax.ws.rs.core.UriBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollabEditingModeSupportHealthCheck
implements SupportHealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(CollabEditingModeSupportHealthCheck.class);
    private static final String SYNCHRONY_CONFIG_URL_PATH = "/admin/confluence-collaborative-editor-plugin/configure.action";
    private final BundleContext bundleContext;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;

    public CollabEditingModeSupportHealthCheck(BundleContext bundleContext, I18nResolver i18nResolver, SystemInformationService systemInformationService) {
        this.bundleContext = bundleContext;
        this.i18nResolver = i18nResolver;
        String baseUrl = systemInformationService.getConfluenceInfo().getBaseUrl();
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, UriBuilder.fromPath((String)baseUrl).path(SYNCHRONY_CONFIG_URL_PATH).build(new Object[0]).getPath());
    }

    public SupportHealthStatus check() {
        try (SynchronyConfigManagerWrapper wrapper = new SynchronyConfigManagerWrapper(this.bundleContext);){
            ServiceReference ref = wrapper.getServiceRef();
            if (ref != null) {
                SynchronyConfigurationManager manager = wrapper.getService();
                boolean isSynchronyEnabled = manager.isSynchronyEnabled();
                boolean isSharedDraftEnabled = manager.isSharedDraftsEnabled();
                if (!isSynchronyEnabled) {
                    if (isSharedDraftEnabled) {
                        SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.collab.editing.mode.limited.fail"), SupportHealthStatus.Severity.WARNING);
                        return supportHealthStatus;
                    }
                    SupportHealthStatus supportHealthStatus = this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.collab.editing.mode.disabled.healthy"));
                    return supportHealthStatus;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.collab.editing.mode.enabled.healthy"));
                return supportHealthStatus;
            }
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.collab.editing.mode.skipped.healthy"));
    }

    private final class SynchronyConfigManagerWrapper
    implements AutoCloseable {
        private final BundleContext bundleContext;
        private final ServiceReference sr;

        SynchronyConfigManagerWrapper(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.sr = bundleContext.getServiceReference("com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager");
        }

        @Override
        public void close() {
            if (this.getServiceRef() != null) {
                this.bundleContext.ungetService(this.sr);
            }
        }

        private ServiceReference getServiceRef() {
            return this.sr;
        }

        private SynchronyConfigurationManager getService() {
            return (SynchronyConfigurationManager)this.bundleContext.getService(this.sr);
        }
    }
}

