/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.license;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public final class LicenseHealthCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "confluence.healthcheck.license.url";
    private final DateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy");
    private final SupportHealthStatusFactory healthStatusFactory;
    private final I18nResolver i18nResolver;
    private final LicenseService licenseService;

    public LicenseHealthCheck(I18nResolver i18nResolver, LicenseService licenseService, HelpPathResolver helpPathResolver) {
        this.i18nResolver = i18nResolver;
        this.licenseService = licenseService;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    public SupportHealthStatus check() {
        ConfluenceLicense license = this.licenseService.retrieve();
        String expiryDateString = this.dateFormatter.format(license.getMaintenanceExpiryDate());
        int daysToExpiry = license.getNumberOfDaysBeforeMaintenanceExpiry();
        if (daysToExpiry < 0) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.license.expired", new Serializable[]{expiryDateString}), SupportHealthStatus.Severity.MAJOR);
        }
        int warningTimePeriod = this.getWarningPeriod(license);
        if (daysToExpiry <= warningTimePeriod) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.license.expiring", new Serializable[]{Integer.valueOf(warningTimePeriod), expiryDateString}), SupportHealthStatus.Severity.WARNING);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.license.valid", new Serializable[]{expiryDateString}));
    }

    private int getWarningPeriod(ConfluenceLicense license) {
        if (license.isEvaluation()) {
            return 7;
        }
        return 30;
    }
}

