/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.jdk;

import com.atlassian.confluence.plugins.healthcheck.common.Version;
import com.atlassian.confluence.status.service.SystemCompatibilityService;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import java.io.Serializable;

public class JdkHealthCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "help.supported.platforms";
    private final I18nResolver i18nResolver;
    private final SystemInformationService systemInformationService;
    private final SystemCompatibilityService systemCompatibilityService;
    private final SupportHealthStatusFactory healthStatusFactory;

    public JdkHealthCheck(I18nResolver i18nResolver, SystemInformationService systemInformationService, SystemCompatibilityService systemCompatibilityService, HelpPathResolver helpPathResolver) {
        this.i18nResolver = i18nResolver;
        this.systemInformationService = systemInformationService;
        this.systemCompatibilityService = systemCompatibilityService;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    public SupportHealthStatus check() {
        String jdkRuntime = this.systemInformationService.getSystemProperties().getJavaRuntime();
        Version jdkVersion = new Version(this.systemInformationService.getSystemProperties().getJavaVersion());
        String failureReason = "";
        if (!jdkRuntime.equals(this.systemCompatibilityService.getSupportedJavaRuntime())) {
            failureReason = failureReason + this.i18nResolver.getText("confluence.healthcheck.jdk.runtime.fail", new Serializable[]{jdkRuntime});
        }
        if (!this.systemCompatibilityService.getSupportedJavaVersions().contains(jdkVersion.getMajorAndMinor())) {
            if (!failureReason.isEmpty()) {
                failureReason = failureReason + " ";
            }
            failureReason = failureReason + this.i18nResolver.getText("confluence.healthcheck.jdk.version.fail", new Serializable[]{jdkVersion.getFullVersion()});
        }
        if (!failureReason.isEmpty()) {
            return this.healthStatusFactory.failed(failureReason, SupportHealthStatus.Severity.CRITICAL);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.jdk.valid", new Serializable[]{jdkVersion.getFullVersion(), jdkRuntime}));
    }
}

