/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.jdk;

import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.LogFileHelper;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCHealthCheck
implements SupportHealthCheck {
    public static final int MAJOR_FAILURE_THRESHOLD = 5;
    public static final int CRITICAL_FAILURE_THRESHOLD = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(GCHealthCheck.class);
    private static final String HELP_PATH = "confluence.healthcheck.gc.url";
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;
    private final LogFileHelper logFileHelper;

    public GCHealthCheck(I18nResolver i18nResolver, HelpPathResolver helpPathResolver, LogFileHelper logFileHelper) {
        this.i18nResolver = i18nResolver;
        this.logFileHelper = logFileHelper;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SupportHealthStatus check() {
        double longestPauseSeconds = 0.0;
        File logDir = this.logFileHelper.getGCLogDir();
        if (logDir == null) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.gc.log.dir.missing.fail"), SupportHealthStatus.Severity.WARNING);
        }
        File currentLog = this.logFileHelper.getCurrentGCLog(logDir);
        if (currentLog == null) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.gc.log.missing.fail", new Serializable[]{this.logFileHelper.getGCLogDir().getAbsolutePath()}), SupportHealthStatus.Severity.WARNING);
        }
        LineIterator lineIterator = null;
        try {
            lineIterator = FileUtils.lineIterator((File)currentLog, (String)"UTF-8");
            while (lineIterator.hasNext()) {
                double pauseTime;
                String line = lineIterator.nextLine();
                if ((line.contains("GC pause") || line.contains("GC cleanup")) && line.endsWith(" secs]")) {
                    String pauseTimeLine = line.substring(0, line.lastIndexOf(" "));
                    double pauseTime2 = Double.parseDouble(pauseTimeLine = pauseTimeLine.substring(pauseTimeLine.lastIndexOf(" ")));
                    if (!(pauseTime2 > longestPauseSeconds)) continue;
                    longestPauseSeconds = pauseTime2;
                    continue;
                }
                if (!line.startsWith(", ") || !((pauseTime = Double.parseDouble(line.substring(2, line.indexOf(" secs]")))) > longestPauseSeconds)) continue;
                longestPauseSeconds = pauseTime;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.gc.log.processing.fail", new Serializable[]{currentLog.getAbsolutePath()}), SupportHealthStatus.Severity.WARNING);
            return supportHealthStatus;
        }
        finally {
            LineIterator.closeQuietly((LineIterator)lineIterator);
        }
        if (longestPauseSeconds > 30.0) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.gc.pausetime.30.fail", new Serializable[]{Double.valueOf(longestPauseSeconds)}), SupportHealthStatus.Severity.CRITICAL);
        }
        if (longestPauseSeconds > 5.0) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.gc.pausetime.5.fail", new Serializable[]{Double.valueOf(longestPauseSeconds)}), SupportHealthStatus.Severity.MAJOR);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.gc.pausetime.valid", new Serializable[]{Double.valueOf(longestPauseSeconds)}));
    }
}

