/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.filesystem;

import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.OperatingSystemInfo;
import java.io.Serializable;

public class OpenFilesLimitCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "confluence.healthcheck.openfiles.url";
    private final OperatingSystemInfo operatingSystemInfo;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;

    public OpenFilesLimitCheck(I18nResolver i18nResolver, HelpPathResolver helpPathResolver, OperatingSystemInfo operatingSystemInfo) {
        this.i18nResolver = i18nResolver;
        this.operatingSystemInfo = operatingSystemInfo;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    public SupportHealthStatus check() {
        long maxFiles = this.operatingSystemInfo.getMaxFileDescriptorCount();
        long openFiles = this.operatingSystemInfo.getOpenFileDescriptorCount();
        float proportion = (float)openFiles / (float)maxFiles;
        float percentage = proportion * 100.0f;
        if (percentage >= 90.0f) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.openfiles.major", new Serializable[]{Long.valueOf(openFiles), Long.valueOf(maxFiles)}), SupportHealthStatus.Severity.MAJOR);
        }
        if (percentage >= 70.0f) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.openfiles.warning", new Serializable[]{Long.valueOf(openFiles), Long.valueOf(maxFiles)}), SupportHealthStatus.Severity.WARNING);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.openfiles.ok", new Serializable[]{Long.valueOf(openFiles), Long.valueOf(maxFiles)}));
    }
}

