/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.eol;

import com.atlassian.confluence.plugins.healthcheck.analytics.EolCheckVersionMissingEvent;
import com.atlassian.confluence.plugins.healthcheck.util.SupportEolCheckUtil;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.core.util.Clock;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EolSupportHealthCheck
implements SupportHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EolSupportHealthCheck.class);
    private static final String HELP_PATH = "confluence.healthcheck.eol.url";
    private static final String EOL_FILE_NAME = "confluence-healthcheck-eol.json";
    private static final String STATUS_EOL_ERROR = "confluence.healthcheck.eol.server.error";
    private static final String STATUS_EOL_FAIL = "confluence.healthcheck.eol.server.fail";
    private static final String STATUS_EOL_WARN = "confluence.healthcheck.eol.server.warn";
    private static final String STATUS_EOL_PASS = "confluence.healthcheck.eol.server.pass";
    private final BootstrapManager bootstrapManager;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final I18nResolver i18nResolver;
    private final SystemInformationService systemInformationService;
    private final SupportHealthStatusFactory healthStatusFactory;

    public EolSupportHealthCheck(BootstrapManager bootstrapManager, Clock clock, EventPublisher eventPublisher, I18nResolver i18nResolver, HelpPathResolver helpPathResolver, SystemInformationService systemInformationService) {
        this.bootstrapManager = bootstrapManager;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.i18nResolver = i18nResolver;
        this.systemInformationService = systemInformationService;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    public SupportHealthStatus check() {
        String[] versionNumbers = this.systemInformationService.getConfluenceInfo().getVersion().split("\\.");
        String versionName = "UNKNOWN";
        try {
            JSONObject versionInfoJson;
            versionName = String.format("%s.%s", versionNumbers[0], versionNumbers[1]);
            File eolFile = new File(this.bootstrapManager.getSharedHome(), EOL_FILE_NAME);
            if (eolFile.exists() && !this.shouldRegeneratePropertiesFile(eolFile.lastModified())) {
                versionInfoJson = this.getVersionJson(versionName, new JSONObject(FileUtils.readFileToString((File)eolFile)));
                if (versionInfoJson == null) {
                    versionInfoJson = this.getVersionJson(versionName, this.getVersionFromMarketplace(eolFile));
                }
            } else {
                versionInfoJson = this.getVersionJson(versionName, this.getVersionFromMarketplace(eolFile));
            }
            if (versionInfoJson == null) {
                this.triggerMissingVersionEvent(versionName);
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String eolDateString = versionInfoJson.getString("releaseDate");
                Date eolDate = formatter.parse(eolDateString);
                if (eolDate != null) {
                    DateTime eol = new DateTime((Object)eolDate);
                    eol = eol.plusYears(2);
                    int daysUntilEol = this.getDaysUntilEol(eol.getMillis());
                    return this.buildSupportHealthStatus(daysUntilEol, versionName);
                }
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException | ParseException ex) {
            LOGGER.error("An error occurred when performing the EOL check, see the exceptions for more info", (Throwable)ex);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText(STATUS_EOL_ERROR, new Serializable[]{versionName}));
    }

    private JSONObject getVersionJson(String versionName, JSONObject versions) throws JSONException {
        JSONArray array = versions.getJSONArray("versions");
        for (int counter = 0; counter < array.length(); ++counter) {
            if (!array.getJSONObject(counter).get("name").equals(versionName)) continue;
            return array.getJSONObject(counter);
        }
        return null;
    }

    private SupportHealthStatus buildSupportHealthStatus(int daysUntilEol, String versionName) {
        int warningDays = this.getNumberOfDaysInSixMonths();
        if (daysUntilEol < 0) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText(STATUS_EOL_FAIL, new Serializable[]{versionName}), SupportHealthStatus.Severity.MAJOR);
        }
        if (daysUntilEol <= warningDays) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText(STATUS_EOL_WARN, new Serializable[]{versionName, Integer.valueOf(daysUntilEol)}), SupportHealthStatus.Severity.WARNING);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText(STATUS_EOL_PASS, new Serializable[]{versionName, Integer.valueOf(daysUntilEol)}));
    }

    @VisibleForTesting
    JSONObject getVersionFromMarketplace(File eolFile) throws IOException {
        return SupportEolCheckUtil.getVersionFromMarketplace(eolFile);
    }

    @VisibleForTesting
    boolean shouldRegeneratePropertiesFile(long lastModified) {
        DateTime modified = new DateTime(lastModified);
        DateTime current = new DateTime(this.clock.getCurrentDate().getTime());
        return Days.daysBetween((ReadableInstant)current, (ReadableInstant)modified).getDays() > 7;
    }

    private int getDaysUntilEol(Long eolDate) {
        DateTime eol = new DateTime((Object)eolDate);
        DateTime current = new DateTime(this.clock.getCurrentDate().getTime());
        return Days.daysBetween((ReadableInstant)current, (ReadableInstant)eol).getDays();
    }

    private int getNumberOfDaysInSixMonths() {
        DateTime current = new DateTime(this.clock.getCurrentDate().getTime());
        DateTime sixMonthsLater = current.plusMonths(6);
        return Days.daysBetween((ReadableInstant)current, (ReadableInstant)sixMonthsLater).getDays();
    }

    private void triggerMissingVersionEvent(String versionName) {
        EolCheckVersionMissingEvent event = new EolCheckVersionMissingEvent(versionName);
        this.eventPublisher.publish((Object)event);
    }
}

