/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.directory.internal;

import com.atlassian.confluence.plugins.healthcheck.analytics.InternalAdminCheckFallbackEvent;
import com.atlassian.confluence.plugins.healthcheck.directory.internal.InternalAdminCheckFallback;
import com.atlassian.confluence.plugins.healthcheck.util.SessionWrapper;
import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.confluence.user.ConfluenceCrowdSSOAuthenticator;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import java.util.Arrays;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAdminCheck
implements SupportHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalAdminCheck.class);
    private static final String HELP_PATH = "confluence.healthcheck.directory.internal.admin.url";
    private static final char ACTIVE = 'T';
    private static final List<String> ADMINISTRATOR_PERM_TYPES = Arrays.asList("ADMINISTRATECONFLUENCE", "SYSTEMADMINISTRATOR");
    private final CrowdDirectoryService crowdDirectoryService;
    private final I18nResolver i18n;
    private final SessionFactory sessionFactory;
    private final SupportHealthStatusFactory supportHealthStatusFactory;
    private final InternalAdminCheckFallback internalAdminCheckFallback;
    private final EventPublisher eventPublisher;

    public InternalAdminCheck(CrowdDirectoryService crowdDirectoryService, HelpPathResolver helpPathResolver, I18nResolver i18n, SessionFactory sessionFactory, InternalAdminCheckFallback internalAdminCheckFallback, EventPublisher eventPublisher) {
        this.supportHealthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
        this.crowdDirectoryService = crowdDirectoryService;
        this.i18n = i18n;
        this.sessionFactory = sessionFactory;
        this.internalAdminCheckFallback = internalAdminCheckFallback;
        this.eventPublisher = eventPublisher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (authenticator instanceof ConfluenceCrowdSSOAuthenticator) {
            return this.supportHealthStatusFactory.healthy(this.i18n.getText("confluence.healthcheck.directory.internal.sso.present"));
        }
        if (!(authenticator instanceof ConfluenceAuthenticator)) {
            return this.supportHealthStatusFactory.healthy(this.i18n.getText("confluence.healthcheck.directory.internal.custom.authenticator"));
        }
        boolean hasInternalDirectory = this.crowdDirectoryService.findAllDirectories().stream().anyMatch(directory -> directory.getType() == DirectoryType.INTERNAL && directory.isActive());
        if (!hasInternalDirectory) {
            return this.supportHealthStatusFactory.failed(this.i18n.getText("confluence.healthcheck.directory.internal.has.internal.dir.fail"), SupportHealthStatus.Severity.MAJOR);
        }
        try (SessionWrapper sw = new SessionWrapper(this.sessionFactory.openSession());){
            int users = this.countUsersInAdminGroupQuery(sw.getSession());
            if (users != 0) return this.supportHealthStatusFactory.healthy(this.i18n.getText("confluence.healthcheck.directory.internal.admin.ok"));
            users = this.countUsersWithAdminPermissionQuery(sw.getSession());
            if (users != 0) return this.supportHealthStatusFactory.healthy(this.i18n.getText("confluence.healthcheck.directory.internal.admin.ok"));
            SupportHealthStatus supportHealthStatus = this.supportHealthStatusFactory.failed(this.i18n.getText("confluence.healthcheck.directory.internal.admin.fail"), SupportHealthStatus.Severity.MAJOR);
            return supportHealthStatus;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred when performing the Internal Administrator User health check, we're going to try to fallback: ", (Throwable)ex);
            this.eventPublisher.publish((Object)new InternalAdminCheckFallbackEvent());
            return this.internalAdminCheckFallback.check();
        }
    }

    private int countUsersInAdminGroupQuery(Session session) throws HibernateException {
        Query query = session.createQuery("select count(distinct cu.name) from HibernateMembership cm left join cm.userMember as cu left join cm.parentGroup as cg left join cu.directory as cd where cg.lowerName in (select sp.group from SpacePermission sp where sp.type in (:permType)) and cu.active = :active and cg.active = :active and cd.type = :directoryType");
        query.setParameterList("permType", ADMINISTRATOR_PERM_TYPES);
        query.setCharacter("active", 'T');
        query.setParameter("directoryType", (Object)DirectoryType.INTERNAL.name());
        return (Integer)query.uniqueResult();
    }

    private int countUsersWithAdminPermissionQuery(Session session) throws HibernateException {
        Query query = session.createQuery("select count(distinct cu.name) from InternalUser cu left join cu.directory as cd where cu.name in(select um.name from SpacePermission sp left join sp.userSubject as um where sp.type in (:permType)) and cu.active = :active and cd.type = :directoryType");
        query.setParameterList("permType", ADMINISTRATOR_PERM_TYPES);
        query.setCharacter("active", 'T');
        query.setParameter("directoryType", (Object)DirectoryType.INTERNAL.name());
        return (Integer)query.uniqueResult();
    }
}

