/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class StorageEngineCheck
extends AbstractMySQLCheck {
    @VisibleForTesting
    static final String TABLE_NAME = "storageenginetest";
    private static final String HELP_PATH = "confluence.healthcheck.mysql.storage.engine.url";
    private final SupportHealthStatusFactory healthStatusFactory;
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private Session session;

    StorageEngineCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try {
            this.session = this.sessionFactory.openSession();
            try {
                this.createTable(this.session, TABLE_NAME);
                String STORAGE_ENGINE_QUERY = String.format("SELECT ENGINE FROM information_schema.TABLES where TABLE_SCHEMA = '%s' and TABLE_NAME = '%s';", this.getDatabaseName(this.session), TABLE_NAME);
                ResultSet resultSet = this.openAndExecuteQuery(this.session, STORAGE_ENGINE_QUERY);
                if (resultSet.next()) {
                    String engine = resultSet.getString("ENGINE");
                    SupportHealthStatus supportHealthStatus2 = engine.equals("InnoDB") ? this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.storage.engine.valid")) : this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.storage.engine.fail"), SupportHealthStatus.Severity.CRITICAL);
                    return supportHealthStatus2;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.database.query.no.results"), SupportHealthStatus.Severity.CRITICAL);
                return supportHealthStatus;
            }
            finally {
                if (this.session != null) {
                    this.dropTable(this.session, "supporthealthchecks");
                }
                this.session.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

