/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.confluence.plugins.healthcheck.util.SessionWrapper;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class SqlModeCheck
extends AbstractMySQLCheck {
    private static final String HELP_PATH = "help.confluence.healthcheck.mysql.sqlmode.url";
    @VisibleForTesting
    static final String GLOBAL_VARS = "SHOW GLOBAL VARIABLES LIKE 'sql_mode';";
    @VisibleForTesting
    static final String SESSION_VARS = "SHOW VARIABLES LIKE 'sql_mode';";
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;

    SqlModeCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try (SessionWrapper sw = new SessionWrapper(this.sessionFactory.openSession());){
            if (!this.isValidSqlMode(sw.getSession(), GLOBAL_VARS).booleanValue() || !this.isValidSqlMode(sw.getSession(), SESSION_VARS).booleanValue()) {
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.sqlmode.fail"), SupportHealthStatus.Severity.CRITICAL);
                return supportHealthStatus;
            }
            SupportHealthStatus supportHealthStatus = this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.sqlmode.valid"));
            return supportHealthStatus;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Boolean isValidSqlMode(Session session, String sql) throws SQLException, HibernateException {
        ResultSet resultSet = this.openAndExecuteQuery(session, sql);
        if (resultSet.next()) {
            String sql_mode = resultSet.getString("VALUE");
            return sql_mode == null || !sql_mode.contains("NO_AUTO_VALUE_ON_ZERO");
        }
        return true;
    }
}

