/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class MaxAllowedPacketsCheck
extends AbstractMySQLCheck {
    @VisibleForTesting
    static final String MAX_PACKETS_QUERY = "show session variables like 'max_allowed_packet';";
    private static final int MAX_PACKETS_RECOMMENDED = 0x2200000;
    private static final String HELP_PATH = "confluence.healthcheck.mysql.max.allowed.packet.url";
    private final SupportHealthStatusFactory healthStatusFactory;
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private Session session;

    MaxAllowedPacketsCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try {
            this.session = this.sessionFactory.openSession();
            try {
                ResultSet resultSet = this.openAndExecuteQuery(this.session, MAX_PACKETS_QUERY);
                if (resultSet.next()) {
                    int maxPackets = resultSet.getInt("Value");
                    SupportHealthStatus supportHealthStatus = maxPackets >= 0x2200000 ? this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.max.packets.valid")) : this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.max.packets.fail", new Serializable[]{Integer.valueOf(maxPackets)}), SupportHealthStatus.Severity.WARNING);
                    return supportHealthStatus;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.database.query.no.results"), SupportHealthStatus.Severity.CRITICAL);
                return supportHealthStatus;
            }
            finally {
                this.session.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

