/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class InnoDBLogFileSizeCheck
extends AbstractMySQLCheck {
    @VisibleForTesting
    static final String LOG_FILE_SIZE_QUERY = "show session variables like 'innodb_log_file_size';";
    private static final int INNODB_LOG_FILE_SIZE_RECOMMENDED = 0x10000000;
    private static final String HELP_PATH = "confluence.healthcheck.mysql.innodb.log.size.url";
    private final SupportHealthStatusFactory healthStatusFactory;
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private Session session;

    public InnoDBLogFileSizeCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try {
            this.session = this.sessionFactory.openSession();
            try {
                ResultSet resultSet = this.openAndExecuteQuery(this.session, LOG_FILE_SIZE_QUERY);
                if (resultSet.next()) {
                    long fileSize = resultSet.getLong("Value");
                    SupportHealthStatus supportHealthStatus = fileSize >= 0x10000000L ? this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.innodb.log.file.size.valid")) : this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.innodb.log.file.size.fail", new Serializable[]{Long.valueOf(fileSize)}), SupportHealthStatus.Severity.WARNING);
                    return supportHealthStatus;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.database.query.no.results"), SupportHealthStatus.Severity.CRITICAL);
                return supportHealthStatus;
            }
            finally {
                this.session.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

