/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class CollationCheck
extends AbstractMySQLCheck {
    private static final String HELP_PATH = "confluence.healthcheck.mysql.collation.url";
    @VisibleForTesting
    static final String DATABASE_COLLATION_QUERY = "SELECT DEFAULT_COLLATION_NAME FROM information_schema.SCHEMATA S\nWHERE schema_name = ?\nAND DEFAULT_COLLATION_NAME != 'utf8_bin';";
    @VisibleForTesting
    static final String TABLE_COLLATION_QUERY = "SELECT T.TABLE_NAME, C.COLLATION_NAME\nFROM information_schema.TABLES AS T, information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` AS C\nWHERE C.collation_name = T.table_collation\nAND T.table_schema = ?\nAND C.COLLATION_NAME != 'utf8_bin';";
    @VisibleForTesting
    static final String COLUMN_COLLATION_QUERY = "SELECT TABLE_NAME, COLUMN_NAME, COLLATION_NAME\nFROM information_schema.COLUMNS\nWHERE TABLE_SCHEMA = ?\nAND COLLATION_NAME != 'utf8_bin';";
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;
    private Session session;

    public CollationCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try {
            this.session = this.sessionFactory.openSession();
            try {
                this.createTable(this.session, "supporthealthchecks");
                ResultSet databaseResultSet = this.openAndExecuteQuery(this.session, DATABASE_COLLATION_QUERY, this.getDatabaseName(this.session));
                ResultSet tableResultSet = this.openAndExecuteQuery(this.session, TABLE_COLLATION_QUERY, this.getDatabaseName(this.session));
                ResultSet columnResultSet = this.openAndExecuteQuery(this.session, COLUMN_COLLATION_QUERY, this.getDatabaseName(this.session));
                if (databaseResultSet.next() || tableResultSet.next() || columnResultSet.next()) {
                    SupportHealthStatus supportHealthStatus2 = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.collation.fail"), SupportHealthStatus.Severity.CRITICAL);
                    return supportHealthStatus2;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.collation.valid"));
                return supportHealthStatus;
            }
            finally {
                if (this.session != null) {
                    this.dropTable(this.session, "supporthealthchecks");
                }
                this.session.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

