/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.confluence.plugins.healthcheck.database.mysql.AbstractMySQLCheck;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.google.common.annotations.VisibleForTesting;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public class CharacterSetCheck
extends AbstractMySQLCheck {
    private static final String HELP_PATH = "confluence.healthcheck.mysql.characterset.url";
    @VisibleForTesting
    static final String DATABASE_CHARACTER_SET_QUERY = "SELECT DEFAULT_CHARACTER_SET_NAME FROM information_schema.SCHEMATA S\nWHERE schema_name = ?\nAND DEFAULT_CHARACTER_SET_NAME != 'utf8';";
    @VisibleForTesting
    static final String TABLE_CHARACTER_SET_QUERY = "SELECT CCSA.character_set_name FROM information_schema.`TABLES` T,\n information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` CCSA\n WHERE CCSA.collation_name = T.table_collation\n AND T.table_schema = ? AND character_set_name != 'utf8';";
    @VisibleForTesting
    static final String COLUMN_CHARACTER_SET_QUERY = "SELECT TABLE_NAME, COLUMN_NAME, CHARACTER_SET_NAME\nFROM information_schema.COLUMNS\nWHERE TABLE_SCHEMA = ?\nAND CHARACTER_SET_NAME != 'utf8';";
    private final SessionFactory sessionFactory;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;
    private Session session;

    public CharacterSetCheck(SessionFactory sessionFactory, I18nResolver i18nResolver, HelpPathResolver helpPathResolver) {
        this.sessionFactory = sessionFactory;
        this.i18nResolver = i18nResolver;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.Confluence, helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportHealthStatus check() {
        try {
            this.session = this.sessionFactory.openSession();
            try {
                this.createTable(this.session, "supporthealthchecks");
                ResultSet databaseResultSet = this.openAndExecuteQuery(this.session, DATABASE_CHARACTER_SET_QUERY, this.getDatabaseName(this.session));
                ResultSet tableResultSet = this.openAndExecuteQuery(this.session, TABLE_CHARACTER_SET_QUERY, this.getDatabaseName(this.session));
                ResultSet columnResultSet = this.openAndExecuteQuery(this.session, COLUMN_CHARACTER_SET_QUERY, this.getDatabaseName(this.session));
                if (tableResultSet.next() || columnResultSet.next() || databaseResultSet.next()) {
                    SupportHealthStatus supportHealthStatus2 = this.healthStatusFactory.failed(this.i18nResolver.getText("confluence.healthcheck.mysql.character.set.fail"), SupportHealthStatus.Severity.CRITICAL);
                    return supportHealthStatus2;
                }
                SupportHealthStatus supportHealthStatus = this.healthStatusFactory.healthy(this.i18nResolver.getText("confluence.healthcheck.mysql.character.set.valid"));
                return supportHealthStatus;
            }
            finally {
                if (this.session != null) {
                    this.dropTable(this.session, "supporthealthchecks");
                    this.session.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

