/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck.database.mysql;

import com.atlassian.support.healthcheck.SupportHealthCheck;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;

public abstract class AbstractMySQLCheck
implements SupportHealthCheck {
    private static final String DB_NAME_QUERY = "SELECT DATABASE() FROM DUAL;";
    private static final String DB_NAME_KEY = "DATABASE()";
    protected static final String TEST_TABLE_NAME = "supporthealthchecks";

    @Nonnull
    protected ResultSet openAndExecuteQuery(Session session, String query) throws SQLException, HibernateException {
        PreparedStatement pStatement = session.connection().prepareStatement(query);
        return pStatement.executeQuery();
    }

    @Nonnull
    protected ResultSet openAndExecuteQuery(Session session, String query, String param1) throws SQLException, HibernateException {
        PreparedStatement pStatement = session.connection().prepareStatement(query);
        pStatement.setString(1, param1);
        return pStatement.executeQuery();
    }

    @Nonnull
    protected ResultSet openAndExecuteQuery(Session session, String query, String param1, String param2) throws SQLException, HibernateException {
        PreparedStatement pStatement = session.connection().prepareStatement(query);
        pStatement.setString(1, param1);
        pStatement.setString(2, param2);
        return pStatement.executeQuery();
    }

    @Nonnull
    protected boolean openAndExecute(Session session, String query) throws SQLException, HibernateException {
        PreparedStatement pStatement = session.connection().prepareStatement(query);
        return pStatement.execute();
    }

    @Nonnull
    protected ResultSet openAndExecute(Session session, String query, String param1) throws SQLException, HibernateException {
        PreparedStatement pStatement = session.connection().prepareStatement(query);
        pStatement.setString(1, param1);
        return pStatement.executeQuery();
    }

    protected String getDatabaseName(Session session) throws SQLException, HibernateException {
        ResultSet resultSet = this.openAndExecuteQuery(session, DB_NAME_QUERY);
        if (resultSet.next()) {
            return resultSet.getString(DB_NAME_KEY);
        }
        return null;
    }

    protected void createTable(Session session, String tableName) throws SQLException, HibernateException {
        String query = String.format("CREATE TABLE IF NOT EXISTS %s.%s (id VARCHAR(45));", this.getDatabaseName(session), tableName);
        this.openAndExecute(session, query);
    }

    protected void dropTable(Session session, String tableName) throws SQLException, HibernateException {
        String query = String.format("DROP TABLE IF EXISTS %s.%s;", this.getDatabaseName(session), tableName);
        this.openAndExecute(session, query);
    }
}

