/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck;

import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;
import com.atlassian.plugin.metadata.RequiredPluginValidator;
import com.google.common.collect.Sets;
import java.util.TreeSet;

public final class RequiredPluginsHealthCheck
implements HealthCheck {
    private static final String NAME = "Required Plugins";
    private static final String DESCRIPTION = "Checks that all required plugins and modules are enabled";
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory("Required Plugins", "Checks that all required plugins and modules are enabled", Application.Confluence);
    private final RequiredPluginValidator requiredPluginValidator;

    public RequiredPluginsHealthCheck(RequiredPluginValidator requiredPluginValidator) {
        this.requiredPluginValidator = requiredPluginValidator;
    }

    public HealthStatus check() {
        TreeSet errors = Sets.newTreeSet((Iterable)this.requiredPluginValidator.validate());
        if (!errors.isEmpty()) {
            return this.healthStatusFactory.failed("The following required plugins and modules are not enabled: " + errors);
        }
        return this.healthStatusFactory.healthy();
    }
}

