/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;

public final class LuceneHealthCheck
implements HealthCheck {
    private static final String NAME = "Lucene";
    private static final String DESCRIPTION = "Checks that the Lucene index is available";
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory("Lucene", "Checks that the Lucene index is available", Application.Confluence);
    private final ILuceneConnection luceneConnection;

    public LuceneHealthCheck(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public HealthStatus check() {
        try {
            this.luceneConnection.getNumDocs();
            return this.healthStatusFactory.healthy();
        }
        catch (LuceneException e) {
            return this.healthStatusFactory.failed(e.getMessage());
        }
    }
}

