/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;
import java.io.File;

public final class HomeDirectoryHealthCheck
implements HealthCheck {
    private static final String NAME = "Home Directory";
    private static final String DESCRIPTION = "Checks that the home directory exists and is readable and writable";
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory("Home Directory", "Checks that the home directory exists and is readable and writable", Application.Confluence);
    private final BootstrapManager bootstrapManager;

    public HomeDirectoryHealthCheck(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public HealthStatus check() {
        File homeDirectory = new File(this.bootstrapManager.getConfluenceHome());
        if (!homeDirectory.exists()) {
            return this.healthStatusFactory.failed("Home directory does not exist");
        }
        if (!homeDirectory.canRead()) {
            return this.healthStatusFactory.failed("Home directory is not readable");
        }
        if (!homeDirectory.canWrite()) {
            return this.healthStatusFactory.failed("Home directory is not writable");
        }
        return this.healthStatusFactory.healthy();
    }
}

