/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck;

import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

public final class DatabaseHealthCheck
implements HealthCheck {
    private static final String NAME = "Database";
    private static final String DESCRIPTION = "Checks that the database is running and responding to queries";
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory("Database", "Checks that the database is running and responding to queries", Application.Confluence);
    private final SessionFactory sessionFactory;

    public DatabaseHealthCheck(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HealthStatus check() {
        HealthStatus healthStatus;
        Session session = this.sessionFactory.openSession();
        try {
            session.connection().createStatement().execute("SELECT count(next_hi) FROM hibernate_unique_key");
            healthStatus = this.healthStatusFactory.healthy();
        }
        catch (Throwable throwable) {
            try {
                session.close();
                throw throwable;
            }
            catch (SQLException e) {
                return this.healthStatusFactory.failed(e.getMessage());
            }
            catch (HibernateException e) {
                return this.healthStatusFactory.failed(e.getMessage());
            }
        }
        session.close();
        return healthStatus;
    }
}

