/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.healthcheck;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.healthcheck.ao.HealthCheckEntity;
import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthCheck;
import com.atlassian.healthcheck.core.HealthStatus;
import com.atlassian.healthcheck.core.HealthStatusFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import net.java.ao.ActiveObjectsException;

public final class ActiveObjectsHealthCheck
implements HealthCheck {
    private static final String NAME = "Active Objects";
    private static final String DESCRIPTION = "Checks that Active Objects is available";
    private final HealthStatusFactory healthStatusFactory = new HealthStatusFactory("Active Objects", "Checks that Active Objects is available", Application.Confluence);
    private final ActiveObjects ao;

    public ActiveObjectsHealthCheck(ActiveObjects ao) {
        this.ao = ao;
    }

    public HealthStatus check() {
        return (HealthStatus)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<HealthStatus>(){

            public HealthStatus doInTransaction() {
                try {
                    ActiveObjectsHealthCheck.this.ao.find(HealthCheckEntity.class);
                    return ActiveObjectsHealthCheck.this.healthStatusFactory.healthy();
                }
                catch (ActiveObjectsException e) {
                    return ActiveObjectsHealthCheck.this.healthStatusFactory.failed(e.getMessage());
                }
            }
        });
    }
}

